/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.group;

import com.arialyy.aria.core.config.Configuration;
import com.arialyy.aria.core.group.AbsSubDLoadUtil;
import com.arialyy.aria.core.group.ISubQueue;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class SimpleSubQueue
implements ISubQueue<AbsSubDLoadUtil> {
    private final String TAG = CommonUtil.getClassName(this.getClass());
    private Map<String, AbsSubDLoadUtil> mCache = new ConcurrentHashMap<String, AbsSubDLoadUtil>();
    private Map<String, AbsSubDLoadUtil> mExec = new ConcurrentHashMap<String, AbsSubDLoadUtil>();
    private int mMaxExecSize;
    private boolean isStopAll = false;

    private SimpleSubQueue() {
        this.mMaxExecSize = Configuration.getInstance().dGroupCfg.getSubMaxTaskNum();
    }

    static SimpleSubQueue newInstance() {
        return new SimpleSubQueue();
    }

    synchronized AbsSubDLoadUtil getLoaderUtil(String key) {
        AbsSubDLoadUtil sub = this.mExec.get(key);
        if (sub != null) {
            return sub;
        }
        return this.mCache.get(key);
    }

    int getCacheSize() {
        return this.mCache.size();
    }

    public int getExecSize() {
        return this.mExec.size();
    }

    boolean isStopAll() {
        return this.isStopAll;
    }

    @Override
    public void addTask(AbsSubDLoadUtil fileer) {
        this.mCache.put(fileer.getKey(), fileer);
    }

    @Override
    public void startTask(AbsSubDLoadUtil fileer) {
        if (this.mExec.size() < this.mMaxExecSize) {
            this.mCache.remove(fileer.getKey());
            this.mExec.put(fileer.getKey(), fileer);
            ALog.d(this.TAG, String.format("\u5f00\u59cb\u6267\u884c\u5b50\u4efb\u52a1\uff1a%s\uff0ckey: %s", fileer.getEntity().getFileName(), fileer.getKey()));
            fileer.run();
            return;
        }
        ALog.d(this.TAG, String.format("\u6267\u884c\u961f\u5217\u5df2\u6ee1\uff0c\u4efb\u52a1\u8fdb\u5165\u7f13\u5b58\u5668\u4e2d\uff0ckey: %s", fileer.getKey()));
        this.addTask(fileer);
    }

    @Override
    public void stopTask(AbsSubDLoadUtil fileer) {
        fileer.stop();
        this.mExec.remove(fileer.getKey());
    }

    @Override
    public void stopAllTask() {
        this.isStopAll = true;
        ALog.d(this.TAG, "\u505c\u6b62\u7ec4\u5408\u4efb\u52a1");
        this.mCache.clear();
        Set<String> keys = this.mExec.keySet();
        for (String key : keys) {
            AbsSubDLoadUtil loader = this.mExec.get(key);
            if (loader == null) continue;
            ALog.d(this.TAG, String.format("\u505c\u6b62\u5b50\u4efb\u52a1\uff1a%s", loader.getEntity().getFileName()));
            loader.stop();
        }
    }

    @Override
    public void modifyMaxExecNum(int num) {
        if (num < 1) {
            ALog.e(this.TAG, String.format("\u4fee\u6539\u7ec4\u5408\u4efb\u52a1\u5b50\u4efb\u52a1\u961f\u5217\u6570\u5931\u8d25\uff0cnum: %s", num));
            return;
        }
        if (num == this.mMaxExecSize) {
            ALog.i(this.TAG, String.format("\u5ffd\u7565\u6b64\u6b21\u4fee\u6539\uff0coldSize: %s, num: %s", this.mMaxExecSize, num));
            return;
        }
        int oldSize = this.mMaxExecSize;
        this.mMaxExecSize = num;
        int diff = Math.abs(oldSize - num);
        if (oldSize < num) {
            if (this.mExec.size() > num) {
                Set<String> keys = this.mExec.keySet();
                ArrayList<AbsSubDLoadUtil> caches = new ArrayList<AbsSubDLoadUtil>();
                int i = 0;
                for (String key : keys) {
                    if (i > num) {
                        caches.add(this.mExec.get(key));
                    }
                    ++i;
                }
                Collection<AbsSubDLoadUtil> temp = this.mCache.values();
                this.mCache.clear();
                for (AbsSubDLoadUtil cache : caches) {
                    this.addTask(cache);
                }
                for (AbsSubDLoadUtil t : temp) {
                    this.addTask(t);
                }
            }
            return;
        }
        if (this.mExec.size() < num) {
            for (int i = 0; i < diff; ++i) {
                AbsSubDLoadUtil next = this.getNextTask();
                if (next != null) {
                    this.startTask(next);
                    continue;
                }
                ALog.d(this.TAG, "\u5b50\u4efb\u52a1\u4e2d\u6ca1\u6709\u7f13\u5b58\u4efb\u52a1");
            }
        }
    }

    @Override
    public void removeTaskFromExecQ(AbsSubDLoadUtil fileer) {
        this.mExec.remove(fileer.getKey());
    }

    @Override
    public void removeTask(AbsSubDLoadUtil fileer) {
        this.removeTaskFromExecQ(fileer);
        this.mCache.remove(fileer.getKey());
    }

    @Override
    public void removeAllTask() {
        ALog.d(this.TAG, "\u5220\u9664\u7ec4\u5408\u4efb\u52a1");
        Set<String> keys = this.mExec.keySet();
        for (String key : keys) {
            AbsSubDLoadUtil loader = this.mExec.get(key);
            if (loader == null) continue;
            ALog.d(this.TAG, String.format("\u505c\u6b62\u5b50\u4efb\u52a1\uff1a%s", loader.getEntity().getFileName()));
            loader.cancel();
        }
    }

    @Override
    public AbsSubDLoadUtil getNextTask() {
        Iterator<String> keys = this.mCache.keySet().iterator();
        if (keys.hasNext()) {
            return this.mCache.get(keys.next());
        }
        return null;
    }

    @Override
    public void clear() {
        this.mCache.clear();
        this.mExec.clear();
    }
}

