/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.loader;

import android.os.Looper;
import android.util.Log;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.ILoader;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.loader.IRecordHandler;
import com.arialyy.aria.core.loader.IThreadTaskBuilder;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class AbsNormalLoader<T extends AbsTaskWrapper>
implements ILoaderVisitor,
ILoader {
    protected final String TAG = CommonUtil.getClassName(this.getClass());
    private IEventListener mListener;
    protected T mTaskWrapper;
    protected File mTempFile;
    private List<IThreadTask> mTask = new ArrayList<IThreadTask>();
    private ScheduledThreadPoolExecutor mTimer;
    private long mUpdateInterval = 1000L;
    protected TaskRecord mRecord;
    protected boolean isCancel = false;
    protected boolean isStop = false;
    private boolean isRuning = false;
    protected IRecordHandler mRecordHandler;
    protected IThreadStateManager mStateManager;
    protected IInfoTask mInfoTask;
    protected IThreadTaskBuilder mTTBuilder;

    protected AbsNormalLoader(T wrapper, IEventListener listener) {
        this.mListener = listener;
        this.mTaskWrapper = wrapper;
    }

    protected abstract void handleTask(Looper var1);

    public abstract long getFileSize();

    protected IEventListener getListener() {
        return this.mListener;
    }

    protected IThreadStateManager getStateManager() {
        return this.mStateManager;
    }

    @Override
    public String getKey() {
        return this.mTaskWrapper.getKey();
    }

    public List<IThreadTask> getTaskList() {
        return this.mTask;
    }

    private void resetState() {
        this.closeTimer();
        if (this.mTask != null && this.mTask.size() != 0) {
            for (int i = 0; i < this.mTask.size(); ++i) {
                this.mTask.get(i).breakTask();
            }
            this.mTask.clear();
        }
    }

    @Override
    public void run() {
        this.checkComponent();
        if (this.isRunning()) {
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u6b63\u5728\u6267\u884c\uff0c\u542f\u52a8\u4efb\u52a1\u5931\u8d25", this.mTaskWrapper.getKey()));
            return;
        }
        this.startFlow();
    }

    private void startFlow() {
        if (this.isBreak()) {
            return;
        }
        Looper.prepare();
        Looper looper = Looper.myLooper();
        if (looper == Looper.getMainLooper()) {
            throw new IllegalThreadStateException("\u4e0d\u80fd\u5728\u4e3b\u7ebf\u7a0b\u7a0b\u5e8f\u4e2d\u8c03\u7528Loader");
        }
        this.isRuning = true;
        this.resetState();
        this.onPostPre();
        this.handleTask(looper);
        Looper.loop();
    }

    protected void onPostPre() {
    }

    protected long delayTimer() {
        return 1000L;
    }

    protected synchronized void startTimer() {
        if (this.isBreak()) {
            return;
        }
        ALog.d(this.TAG, String.format("\u542f\u52a8\u5b9a\u65f6\u5668\uff0cdelayTimer = %s, updateInterval = %s", this.delayTimer(), this.mUpdateInterval));
        this.closeTimer();
        try {
            this.mTimer = new ScheduledThreadPoolExecutor(1);
            this.mTimer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (AbsNormalLoader.this.mStateManager == null) {
                            ALog.e(AbsNormalLoader.this.TAG, "stateManager is null");
                        } else if (AbsNormalLoader.this.mStateManager.isComplete() || AbsNormalLoader.this.mStateManager.isFail() || !AbsNormalLoader.this.isRunning() || AbsNormalLoader.this.isBreak()) {
                            ThreadTaskManager.getInstance().removeTaskThread(AbsNormalLoader.this.mTaskWrapper.getKey());
                            AbsNormalLoader.this.closeTimer();
                            AbsNormalLoader.this.onDestroy();
                        } else if (AbsNormalLoader.this.mStateManager.getCurrentProgress() >= 0L) {
                            Log.d((String)AbsNormalLoader.this.TAG, (String)"running...");
                            AbsNormalLoader.this.mListener.onProgress(AbsNormalLoader.this.mStateManager.getCurrentProgress());
                        } else {
                            Log.d((String)AbsNormalLoader.this.TAG, (String)"\u672a\u77e5\u72b6\u6001");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, this.delayTimer(), this.mUpdateInterval, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            ALog.e(this.TAG, "\u542f\u52a8\u5b9a\u65f6\u5668\u5931\u8d25");
            e.printStackTrace();
        }
    }

    private synchronized void closeTimer() {
        if (this.mTimer != null && !this.mTimer.isShutdown()) {
            this.mTimer.shutdown();
        }
    }

    public void onDestroy() {
        this.isRuning = false;
    }

    protected void setUpdateInterval(long interval) {
        if (interval < 0L) {
            ALog.w(this.TAG, "\u66f4\u65b0\u95f4\u9694\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u9ed8\u8ba4\u4e3a1000\u6beb\u79d2");
            return;
        }
        this.mUpdateInterval = interval;
    }

    @Override
    public synchronized boolean isRunning() {
        boolean b = ThreadTaskManager.getInstance().taskIsRunning(this.mTaskWrapper.getKey());
        return b && this.isRuning;
    }

    @Override
    public final synchronized void cancel() {
        if (this.isCancel) {
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u6b63\u5728\u5220\u9664\uff0c\u5220\u9664\u4efb\u52a1\u5931\u8d25", this.mTaskWrapper.getKey()));
            return;
        }
        if (this.mInfoTask != null) {
            this.mInfoTask.cancel();
        }
        this.closeTimer();
        this.isCancel = true;
        this.onCancel();
        for (int i = 0; i < this.mTask.size(); ++i) {
            IThreadTask task = this.mTask.get(i);
            if (task == null || task.isThreadComplete()) continue;
            task.cancel();
        }
        ThreadTaskManager.getInstance().removeTaskThread(this.mTaskWrapper.getKey());
        this.onPostCancel();
        this.onDestroy();
        this.mListener.onCancel();
    }

    protected void onCancel() {
    }

    protected void onPostCancel() {
    }

    @Override
    public final synchronized void stop() {
        if (this.isStop) {
            return;
        }
        if (this.mInfoTask != null) {
            this.mInfoTask.stop();
        }
        this.closeTimer();
        this.isStop = true;
        this.onStop();
        for (int i = 0; i < this.mTask.size(); ++i) {
            IThreadTask task = this.mTask.get(i);
            if (task == null || task.isThreadComplete()) continue;
            task.stop();
        }
        ThreadTaskManager.getInstance().removeTaskThread(this.mTaskWrapper.getKey());
        this.onPostStop();
        this.onDestroy();
        this.mListener.onStop(this.getCurrentProgress());
    }

    protected void onStop() {
    }

    protected void onPostStop() {
    }

    public void retryTask() {
        ALog.w(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5f00\u59cb\u91cd\u8bd5", this.mTaskWrapper.getKey()));
        this.startFlow();
    }

    @Override
    public boolean isBreak() {
        if (this.isCancel || this.isStop) {
            ALog.d(this.TAG, "isCancel = " + this.isCancel + ", isStop = " + this.isStop);
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u505c\u6b62\u6216\u53d6\u6d88\u4e86", this.mTaskWrapper.getKey()));
            return true;
        }
        return false;
    }

    protected void checkComponent() {
        if (this.mRecordHandler == null) {
            throw new NullPointerException("\u4efb\u52a1\u8bb0\u5f55\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.mInfoTask == null) {
            throw new NullPointerException("\u6587\u4ef6\u4fe1\u606f\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.mStateManager == null) {
            throw new NullPointerException("\u4efb\u52a1\u72b6\u6001\u7ba1\u7406\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.mTTBuilder == null) {
            throw new NullPointerException("\u7ebf\u7a0b\u4efb\u52a1\u7ec4\u4ef6\u4e3a\u7a7a");
        }
    }
}

