/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.loader;

import android.os.Handler;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsNormalEntity;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.task.IThreadTaskAdapter;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.CommonUtil;
import java.io.File;

public abstract class AbsNormalTTBuilderAdapter {
    protected String TAG = CommonUtil.getClassName(this);
    protected AbsTaskWrapper wrapper;
    private File tempFile;

    protected void setWrapper(AbsTaskWrapper wrapper) {
        this.wrapper = wrapper;
        this.tempFile = new File(((AbsNormalEntity)wrapper.getEntity()).getFilePath());
    }

    public abstract IThreadTaskAdapter getAdapter(SubThreadConfig var1);

    public abstract boolean handleNewTask(TaskRecord var1, int var2);

    protected SubThreadConfig getSubThreadConfig(Handler stateHandler, ThreadRecord threadRecord, boolean isBlock, int startNum) {
        return this.createNormalSubThreadConfig(stateHandler, threadRecord, isBlock, startNum);
    }

    private SubThreadConfig createNormalSubThreadConfig(Handler stateHandler, ThreadRecord threadRecord, boolean isBlock, int startNum) {
        SubThreadConfig config = new SubThreadConfig();
        config.url = this.getEntity().isRedirect() ? this.getEntity().getRedirectUrl() : this.getEntity().getUrl();
        config.tempFile = isBlock ? new File(String.format("%s.%s.part", this.tempFile.getPath(), threadRecord.threadId)) : this.tempFile;
        config.isBlock = isBlock;
        config.startThreadNum = startNum;
        config.taskWrapper = this.wrapper;
        config.record = threadRecord;
        config.stateHandler = stateHandler;
        config.threadType = SubThreadConfig.getThreadType(this.wrapper.getRequestType());
        config.updateInterval = SubThreadConfig.getUpdateInterval(this.wrapper.getRequestType());
        return config;
    }

    protected AbsNormalEntity getEntity() {
        return (AbsNormalEntity)this.wrapper.getEntity();
    }

    protected File getTempFile() {
        return this.tempFile;
    }
}

