/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.loader;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class GroupSubThreadStateManager
implements IThreadStateManager {
    private final String TAG = CommonUtil.getClassName(this);
    private Handler mHandler;
    private int mThreadNum;
    private AtomicInteger mCancelNum = new AtomicInteger(0);
    private AtomicInteger mStopNum = new AtomicInteger(0);
    private AtomicInteger mFailNum = new AtomicInteger(0);
    private AtomicInteger mCompleteNum = new AtomicInteger(0);
    private long mProgress;
    private TaskRecord mTaskRecord;
    private Looper mLooper;
    private String mKey;
    private Handler.Callback callback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            GroupSubThreadStateManager.this.checkLooper();
            switch (msg.what) {
                case 1: {
                    GroupSubThreadStateManager.this.mStopNum.getAndIncrement();
                    if (GroupSubThreadStateManager.this.isStop()) {
                        GroupSubThreadStateManager.this.quitLooper();
                    }
                    this.sendMessageFromMsg(msg);
                    break;
                }
                case 3: {
                    GroupSubThreadStateManager.this.mCancelNum.getAndIncrement();
                    if (GroupSubThreadStateManager.this.isCancel()) {
                        GroupSubThreadStateManager.this.quitLooper();
                    }
                    this.sendMessageFromMsg(msg);
                    break;
                }
                case 2: {
                    GroupSubThreadStateManager.this.mFailNum.getAndIncrement();
                    if (!GroupSubThreadStateManager.this.isFail()) break;
                    this.sendMessageFromMsg(msg);
                    GroupSubThreadStateManager.this.quitLooper();
                    break;
                }
                case 4: {
                    GroupSubThreadStateManager.this.mCompleteNum.getAndIncrement();
                    if (GroupSubThreadStateManager.this.isComplete()) {
                        ALog.d(GroupSubThreadStateManager.this.TAG, "isComplete, completeNum = " + GroupSubThreadStateManager.this.mCompleteNum);
                        if (((GroupSubThreadStateManager)GroupSubThreadStateManager.this).mTaskRecord.isBlock) {
                            if (!GroupSubThreadStateManager.this.mergeFile()) {
                                Bundle b = msg.getData();
                                b.putBoolean("DATA_RETRY", false);
                                msg.setData(b);
                                msg.what = 2;
                                this.sendMessageFromMsg(msg);
                            }
                            this.sendMessageFromMsg(msg);
                        } else {
                            this.sendMessageFromMsg(msg);
                        }
                        GroupSubThreadStateManager.this.quitLooper();
                        break;
                    }
                    if (!GroupSubThreadStateManager.this.isFail()) break;
                    this.sendMessageFromMsg(msg);
                    GroupSubThreadStateManager.this.quitLooper();
                    break;
                }
                case 5: {
                    Bundle b = msg.getData();
                    if (b != null) {
                        long len = b.getLong("DATA_ADD_LEN", 0L);
                        GroupSubThreadStateManager.this.mProgress = GroupSubThreadStateManager.this.mProgress + len;
                    }
                    msg.obj = GroupSubThreadStateManager.this.mProgress;
                    this.sendMessageFromMsg(msg);
                    break;
                }
                case 6: {
                    if (msg.obj == null) {
                        GroupSubThreadStateManager.this.mProgress = GroupSubThreadStateManager.this.updateBlockProgress();
                    } else if (msg.obj instanceof Long) {
                        GroupSubThreadStateManager.this.mProgress = (Long)msg.obj;
                    }
                    msg.obj = GroupSubThreadStateManager.this.mProgress;
                    this.sendMessageFromMsg(msg);
                }
            }
            return false;
        }

        public void sendMessageFromMsg(Message msg) {
            Message mMsg = GroupSubThreadStateManager.this.mHandler.obtainMessage();
            Bundle b = mMsg.getData();
            b.putString("DATA_THREAD_NAME", GroupSubThreadStateManager.this.mKey);
            msg.setData(b);
            mMsg.copyFrom(msg);
            GroupSubThreadStateManager.this.mHandler.sendMessage(mMsg);
        }
    };

    public GroupSubThreadStateManager(Handler handler, String key) {
        this.mHandler = handler;
        this.mKey = key;
    }

    @Override
    public void setLooper(TaskRecord taskRecord, Looper looper) {
        this.mTaskRecord = taskRecord;
        this.mThreadNum = this.mTaskRecord.threadNum;
        this.mLooper = looper;
    }

    private void checkLooper() {
        if (this.mTaskRecord == null) {
            throw new NullPointerException("\u4efb\u52a1\u8bb0\u5f55\u4e3a\u7a7a");
        }
        if (this.mLooper == null) {
            throw new NullPointerException("Looper\u4e3a\u7a7a");
        }
    }

    @Override
    public void updateCurrentProgress(long currentProgress) {
        this.mProgress = currentProgress;
    }

    private void quitLooper() {
        this.mLooper.quit();
    }

    @Override
    public long getCurrentProgress() {
        return this.mProgress;
    }

    @Override
    public Handler.Callback getHandlerCallback() {
        return this.callback;
    }

    public boolean isStop() {
        return this.mStopNum.get() == this.mThreadNum || this.mStopNum.get() + this.mCompleteNum.get() == this.mThreadNum;
    }

    @Override
    public boolean isFail() {
        return this.mCompleteNum.get() != this.mThreadNum && (this.mFailNum.get() == this.mThreadNum || this.mFailNum.get() + this.mCompleteNum.get() == this.mThreadNum);
    }

    @Override
    public boolean isComplete() {
        return this.mCompleteNum.get() == this.mThreadNum;
    }

    public boolean isCancel() {
        return this.mCancelNum.get() == this.mThreadNum;
    }

    private long updateBlockProgress() {
        long size = 0L;
        int len = this.mTaskRecord.threadRecords.size();
        for (int i = 0; i < len; ++i) {
            File temp = new File(String.format("%s.%s.part", this.mTaskRecord.filePath, i));
            if (!temp.exists()) continue;
            size += temp.length();
        }
        return size;
    }

    private boolean mergerSFtp() {
        if (this.mTaskRecord.threadNum == 1) {
            File partFile = new File(String.format("%s.%s.part", this.mTaskRecord.filePath, 0));
            return partFile.renameTo(new File(this.mTaskRecord.filePath));
        }
        ArrayList<String> partPath = new ArrayList<String>();
        int len = this.mTaskRecord.threadNum;
        for (int i = 0; i < len; ++i) {
            partPath.add(String.format("%s.%s.part", this.mTaskRecord.filePath, i));
        }
        FileUtil.mergeSFtpFile(this.mTaskRecord.filePath, partPath, this.mTaskRecord.fileLength);
        for (String pp : partPath) {
            FileUtil.deleteFile(pp);
        }
        return true;
    }

    private boolean mergeFile() {
        if (this.mTaskRecord.threadNum == 1) {
            File partFile = new File(String.format("%s.%s.part", this.mTaskRecord.filePath, 0));
            return partFile.renameTo(new File(this.mTaskRecord.filePath));
        }
        ArrayList<String> partPath = new ArrayList<String>();
        int len = this.mTaskRecord.threadNum;
        for (int i = 0; i < len; ++i) {
            partPath.add(String.format("%s.%s.part", this.mTaskRecord.filePath, i));
        }
        boolean isSuccess = FileUtil.mergeFile(this.mTaskRecord.filePath, partPath);
        if (isSuccess) {
            for (String pp : partPath) {
                FileUtil.deleteFile(pp);
            }
            File targetFile = new File(this.mTaskRecord.filePath);
            if (targetFile.exists() && targetFile.length() > this.mTaskRecord.fileLength) {
                ALog.e(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5206\u5757\u6587\u4ef6\u5408\u5e76\u5931\u8d25\uff0c\u4e0b\u8f7d\u957f\u5ea6\u8d85\u51fa\u6587\u4ef6\u771f\u5b9e\u957f\u5ea6\uff0cdownloadLen: %s\uff0cfileSize: %s", targetFile.getName(), targetFile.length(), this.mTaskRecord.fileLength));
                return false;
            }
            return true;
        }
        ALog.e(this.TAG, "\u5408\u5e76\u5931\u8d25");
        return false;
    }

    @Override
    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent(this);
    }
}

