/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.loader;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsNormalEntity;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.loader.AbsNormalTTBuilderAdapter;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.loader.IThreadTaskBuilder;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.task.ThreadTask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;

public final class NormalTTBuilder
implements IThreadTaskBuilder {
    protected String TAG = CommonUtil.getClassName(this);
    private Handler mStateHandler;
    private AbsTaskWrapper mWrapper;
    private TaskRecord mRecord;
    private int mTotalThreadNum;
    private int mStartThreadNum;
    private AbsNormalTTBuilderAdapter mAdapter;

    public NormalTTBuilder(AbsTaskWrapper wrapper, AbsNormalTTBuilderAdapter adapter) {
        if (wrapper instanceof DGTaskWrapper) {
            throw new AssertionError((Object)"NormalTTBuilder \u4e0d\u9002\u7528\u4e8e\u7ec4\u5408\u4efb\u52a1");
        }
        this.mWrapper = wrapper;
        this.mAdapter = adapter;
        this.mAdapter.setWrapper(wrapper);
    }

    protected AbsNormalEntity getEntity() {
        return (AbsNormalEntity)this.mWrapper.getEntity();
    }

    public AbsNormalTTBuilderAdapter getAdapter() {
        return this.mAdapter;
    }

    private IThreadTask createThreadTask(SubThreadConfig config) {
        ThreadTask task = new ThreadTask(config);
        task.setAdapter(this.mAdapter.getAdapter(config));
        return task;
    }

    private IThreadTask createSingThreadTask(ThreadRecord record, int startNum) {
        return this.createThreadTask(this.mAdapter.getSubThreadConfig(this.mStateHandler, record, this.mRecord.isBlock, startNum));
    }

    private List<IThreadTask> handleNoSupportBP() {
        ArrayList<IThreadTask> list = new ArrayList<IThreadTask>();
        this.mStartThreadNum = 1;
        this.mRecord.isBlock = false;
        this.mRecord.update();
        IThreadTask task = this.createSingThreadTask(this.mRecord.threadRecords.get(0), 1);
        list.add(task);
        return list;
    }

    private List<IThreadTask> handleBreakpoint() {
        long fileLength = this.getEntity().getFileSize();
        long blockSize = fileLength / (long)this.mTotalThreadNum;
        long currentProgress = 0L;
        ArrayList<IThreadTask> threadTasks = new ArrayList<IThreadTask>(this.mTotalThreadNum);
        this.mRecord.fileLength = fileLength;
        if (this.mWrapper.isNewTask() && !this.mAdapter.handleNewTask(this.mRecord, this.mTotalThreadNum)) {
            ALog.e(this.TAG, "\u521d\u59cb\u5316\u7ebf\u7a0b\u4efb\u52a1\u5931\u8d25");
            return null;
        }
        for (ThreadRecord tr : this.mRecord.threadRecords) {
            if (tr.isComplete) continue;
            ++this.mStartThreadNum;
        }
        for (int i = 0; i < this.mTotalThreadNum; ++i) {
            long startL = (long)i * blockSize;
            long endL = (long)(i + 1) * blockSize;
            ThreadRecord tr = this.mRecord.threadRecords.get(i);
            if (tr.isComplete) {
                currentProgress += endL - startL;
                ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u7ebf\u7a0b__%s__\u5df2\u5b8c\u6210", this.mWrapper.getKey(), i));
                Message msg = this.mStateHandler.obtainMessage();
                msg.what = 4;
                Bundle b = msg.getData();
                if (b == null) {
                    b = new Bundle();
                }
                b.putString("DATA_THREAD_NAME", CommonUtil.getThreadName(this.getEntity().getKey(), tr.threadId));
                msg.setData(b);
                msg.sendToTarget();
                continue;
            }
            long r = tr.startLocation;
            if (startL < r && r <= (i == this.mTotalThreadNum - 1 ? fileLength : endL)) {
                currentProgress += r - startL;
            }
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u7ebf\u7a0b__%s__\u6062\u590d\u4efb\u52a1", this.getEntity().getFileName(), i));
            IThreadTask task = this.createSingThreadTask(tr, this.mStartThreadNum);
            if (task == null) {
                ALog.e(this.TAG, "\u521b\u5efa\u7ebf\u7a0b\u4efb\u52a1\u5931\u8d25");
                return null;
            }
            threadTasks.add(task);
        }
        if (currentProgress != this.getEntity().getCurrentProgress()) {
            ALog.d(this.TAG, String.format("\u8fdb\u5ea6\u4fee\u6b63\uff0c\u5f53\u524d\u8fdb\u5ea6\uff1a%s", currentProgress));
            this.getEntity().setCurrentProgress(currentProgress);
        }
        return threadTasks;
    }

    private List<IThreadTask> handleTask() {
        if (this.mWrapper.isSupportBP()) {
            return this.handleBreakpoint();
        }
        return this.handleNoSupportBP();
    }

    @Override
    public List<IThreadTask> buildThreadTask(TaskRecord record, Handler stateHandler) {
        this.mRecord = record;
        this.mStateHandler = stateHandler;
        this.mTotalThreadNum = this.mRecord.threadNum;
        return this.handleTask();
    }

    @Override
    public int getCreatedThreadNum() {
        return this.mStartThreadNum;
    }

    @Override
    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent(this);
    }
}

