/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.task;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.inf.IUtil;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.task.ITask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.ComponentUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class AbsTask<TASK_WRAPPER extends AbsTaskWrapper>
implements ITask<TASK_WRAPPER> {
    public static final String ERROR_INFO_KEY = "ERROR_INFO_KEY";
    protected String TAG = CommonUtil.getClassName(this.getClass());
    private boolean needRetry = true;
    protected TASK_WRAPPER mTaskWrapper;
    protected Handler mOutHandler;
    protected Context mContext;
    protected boolean isHeighestTask = false;
    private boolean isCancel = false;
    private boolean isStop = false;
    private IUtil mUtil;
    private Map<String, Object> mExpand = new HashMap<String, Object>();
    private int mSchedulerType = 1;
    protected IEventListener mListener;

    protected AbsTask() {
    }

    public Handler getOutHandler() {
        return this.mOutHandler;
    }

    synchronized IUtil getUtil() {
        if (this.mUtil == null) {
            this.mUtil = ComponentUtil.getInstance().buildUtil((AbsTaskWrapper)this.mTaskWrapper, this.mListener);
        }
        return this.mUtil;
    }

    public int getTimeLeft() {
        return ((AbsEntity)((AbsTaskWrapper)this.getTaskWrapper()).getEntity()).getTimeLeft();
    }

    public String getConvertTimeLeft() {
        return CommonUtil.formatTime(((AbsEntity)((AbsTaskWrapper)this.getTaskWrapper()).getEntity()).getTimeLeft());
    }

    public void putExpand(String key, Object obj) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            ALog.e(this.TAG, "key \u4e3a\u7a7a");
            return;
        }
        if (obj == null) {
            ALog.i(this.TAG, "\u6269\u5c55\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        this.mExpand.put(key, obj);
    }

    @Override
    public boolean isNeedRetry() {
        return this.needRetry;
    }

    public void setNeedRetry(boolean needRetry) {
        this.needRetry = needRetry;
    }

    public void setHighestPriority(boolean isHighestPriority) {
        this.isHeighestTask = isHighestPriority;
    }

    @Override
    public Object getExpand(String key) {
        return this.mExpand.get(key);
    }

    public boolean isComplete() {
        return ((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).isComplete();
    }

    public long getCurrentProgress() {
        return ((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getCurrentProgress();
    }

    public String getConvertCurrentProgress() {
        if (((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getCurrentProgress() == 0L) {
            return "0b";
        }
        return CommonUtil.formatFileSize(((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getCurrentProgress());
    }

    public String getConvertFileSize() {
        if (((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getFileSize() == 0L) {
            return "0mb";
        }
        return CommonUtil.formatFileSize(((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getFileSize());
    }

    public long getFileSize() {
        return ((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getFileSize();
    }

    public int getPercent() {
        return ((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getPercent();
    }

    @Override
    public int getState() {
        return ((AbsTaskWrapper)this.mTaskWrapper).getState();
    }

    public String getExtendField() {
        return ((AbsTaskWrapper)this.mTaskWrapper).getEntity() == null ? null : ((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getStr();
    }

    @Override
    public void start() {
        this.start(1);
    }

    @Override
    public void start(int type) {
        this.mSchedulerType = type;
        this.mUtil = this.getUtil();
        if (this.mUtil == null) {
            ALog.e(this.TAG, "\u4efb\u52a1\u5de5\u5177\u521b\u5efa\u5931\u8d25");
            return;
        }
        if (type == 5) {
            if (this.getUtil().isRunning()) {
                ALog.e(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u91cd\u542f\u5931\u8d25", this.getTaskName()));
                return;
            }
            this.mUtil.start();
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u91cd\u542f\u6210\u529f", this.getTaskName()));
            return;
        }
        if (this.getUtil().isRunning()) {
            ALog.d(this.TAG, "\u4efb\u52a1\u6b63\u5728\u4e0b\u8f7d");
        } else {
            this.getUtil().start();
        }
    }

    @Override
    public void stop() {
        this.stop(1);
    }

    @Override
    public void stop(int type) {
        this.mUtil = this.getUtil();
        if (this.mUtil == null) {
            ALog.e(this.TAG, "\u4efb\u52a1\u5de5\u5177\u521b\u5efa\u5931\u8d25");
            return;
        }
        this.isStop = true;
        this.mSchedulerType = type;
        this.getUtil().stop();
    }

    @Override
    public void cancel() {
        this.cancel(1);
    }

    @Override
    public void cancel(int type) {
        this.mUtil = this.getUtil();
        if (this.mUtil == null) {
            ALog.e(this.TAG, "\u4efb\u52a1\u5de5\u5177\u521b\u5efa\u5931\u8d25");
            return;
        }
        this.isCancel = true;
        this.mSchedulerType = type;
        this.getUtil().cancel();
    }

    @Override
    public boolean isRunning() {
        return this.getUtil().isRunning();
    }

    @Override
    public int getSchedulerType() {
        return this.mSchedulerType;
    }

    @Override
    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    public boolean isStop() {
        return this.isStop;
    }

    public long getSpeed() {
        return ((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getSpeed();
    }

    public String getConvertSpeed() {
        return ((AbsEntity)((AbsTaskWrapper)this.mTaskWrapper).getEntity()).getConvertSpeed();
    }

    @Override
    public TASK_WRAPPER getTaskWrapper() {
        return this.mTaskWrapper;
    }

    public boolean isHighestPriorityTask() {
        return this.isHeighestTask;
    }
}

