/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.task;

import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.config.BaseTaskConfig;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.task.IThreadTaskAdapter;
import com.arialyy.aria.core.task.IThreadTaskObserver;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.util.BandwidthLimiter;
import com.arialyy.aria.util.CommonUtil;

public abstract class AbsThreadTaskAdapter
implements IThreadTaskAdapter {
    protected String TAG = CommonUtil.getClassName(this.getClass());
    protected BandwidthLimiter mSpeedBandUtil;
    private ThreadRecord mThreadRecord;
    private IThreadTaskObserver mObserver;
    private AbsTaskWrapper mWrapper;
    private SubThreadConfig mThreadConfig;
    private IThreadTask mThreadTask;

    protected AbsThreadTaskAdapter(SubThreadConfig config) {
        this.mThreadRecord = config.record;
        this.mWrapper = config.taskWrapper;
        this.mThreadConfig = config;
        if (this.getTaskConfig().getMaxSpeed() > 0) {
            this.mSpeedBandUtil = new BandwidthLimiter(this.getTaskConfig().getMaxSpeed(), config.startThreadNum);
        }
    }

    @Override
    public void call(IThreadTask threadTask) throws Exception {
        this.mThreadTask = threadTask;
        this.handlerThreadTask();
    }

    protected abstract void handlerThreadTask();

    protected long getRangeProgress() {
        return this.mObserver.getThreadProgress();
    }

    protected ThreadRecord getThreadRecord() {
        return this.mThreadRecord;
    }

    protected AbsTaskWrapper getTaskWrapper() {
        return this.mWrapper;
    }

    protected BaseTaskConfig getTaskConfig() {
        return this.getTaskWrapper().getConfig();
    }

    protected IThreadTask getThreadTask() {
        return this.mThreadTask;
    }

    protected SubThreadConfig getThreadConfig() {
        return this.mThreadConfig;
    }

    @Override
    public void attach(IThreadTaskObserver observer) {
        this.mObserver = observer;
    }

    @Override
    public void setMaxSpeed(int speed) {
        if (this.mSpeedBandUtil == null) {
            this.mSpeedBandUtil = new BandwidthLimiter(this.getTaskConfig().getMaxSpeed(), this.getThreadConfig().startThreadNum);
        }
        this.mSpeedBandUtil.setMaxRate(speed);
    }

    protected void complete() {
        if (this.mObserver != null) {
            this.mObserver.updateCompleteState();
        }
    }

    protected void fail(AriaException ex, boolean needRetry) {
        if (this.mObserver != null) {
            this.mObserver.updateFailState(ex, needRetry);
        }
    }

    protected void progress(long len) {
        if (this.mObserver != null) {
            this.mObserver.updateProgress(len);
        }
    }
}

