/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.orm;

import com.arialyy.aria.orm.AbsDbWrapper;
import com.arialyy.aria.orm.DelegateWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class DbEntity {
    private static final Object LOCK = new Object();
    public long rowID = -1L;

    protected DbEntity() {
    }

    protected long getRowID() {
        return this.rowID;
    }

    public static <T extends AbsDbWrapper> List<T> findRelationData(Class<T> clazz, String ... expression) {
        return DelegateWrapper.getInstance().findRelationData(clazz, expression);
    }

    public static <T extends AbsDbWrapper> List<T> findRelationData(Class<T> clazz, int page, int num, String ... expression) {
        if (page < 1 || num < 1) {
            return null;
        }
        return DelegateWrapper.getInstance().findRelationData(clazz, page, num, expression);
    }

    public static boolean checkDataExist(Class clazz, String ... expression) {
        return DelegateWrapper.getInstance().checkDataExist(clazz, expression);
    }

    public static <T extends DbEntity> void clean(Class<T> clazz) {
        DelegateWrapper.getInstance().clean(clazz);
    }

    public static void exeSql(String sql) {
        DelegateWrapper.getInstance().exeSql(sql);
    }

    public static <T extends DbEntity> List<T> findAllData(Class<T> clazz) {
        return DelegateWrapper.getInstance().findAllData(clazz);
    }

    public static <T extends DbEntity> T findFirst(Class<T> clazz) {
        List<T> list = DbEntity.findAllData(clazz);
        return (T)(list == null || list.size() == 0 ? null : (DbEntity)list.get(0));
    }

    public static <T extends DbEntity> List<T> findDatas(Class<T> clazz, String ... expression) {
        return DelegateWrapper.getInstance().findData(clazz, expression);
    }

    public static <T extends DbEntity> List<T> findDatas(Class<T> clazz, int page, int num, String ... expression) {
        if (page < 1 || num < 1) {
            return null;
        }
        return DelegateWrapper.getInstance().findData(clazz, page, num, expression);
    }

    public static <T extends DbEntity> List<T> findDataByFuzzy(Class<T> clazz, String conditions) {
        return DelegateWrapper.getInstance().findDataByFuzzy(clazz, conditions);
    }

    public static <T extends DbEntity> List<T> findDataByFuzzy(Class<T> clazz, int page, int num, String conditions) {
        return DelegateWrapper.getInstance().findDataByFuzzy(clazz, page, num, conditions);
    }

    public static <T extends DbEntity> T findFirst(Class<T> clazz, String ... expression) {
        DelegateWrapper util = DelegateWrapper.getInstance();
        List<T> datas = util.findData(clazz, expression);
        return (T)(datas == null ? null : (datas.size() > 0 ? (DbEntity)datas.get(0) : null));
    }

    public static <T extends DbEntity> void insertManyData(List<T> entities) {
        DbEntity.checkListData(entities);
        DelegateWrapper.getInstance().insertManyData(entities);
    }

    public static <T extends DbEntity> void updateManyData(List<T> entities) {
        DbEntity.checkListData(entities);
        DelegateWrapper.getInstance().updateManyData(entities);
    }

    public static <T extends DbEntity> void saveAll(List<T> entities) {
        DbEntity.checkListData(entities);
        ArrayList<DbEntity> insertD = new ArrayList<DbEntity>();
        ArrayList<DbEntity> updateD = new ArrayList<DbEntity>();
        DelegateWrapper wrapper = DelegateWrapper.getInstance();
        for (DbEntity entity : entities) {
            if (entity.rowID == -1L) {
                insertD.add(entity);
                continue;
            }
            if (wrapper.isExist(entity.getClass(), entity.rowID)) {
                updateD.add(entity);
                continue;
            }
            insertD.add(entity);
        }
        if (!insertD.isEmpty()) {
            wrapper.insertManyData(insertD);
        }
        if (!updateD.isEmpty()) {
            wrapper.updateManyData(updateD);
        }
    }

    private static <T extends DbEntity> void checkListData(List<T> entities) {
        if (entities == null || entities.isEmpty()) {
            throw new NullPointerException("\u5217\u8868\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public void deleteData() {
        DbEntity.deleteData(this.getClass(), "rowid=?", this.rowID + "");
    }

    public static <T extends DbEntity> void deleteData(Class<T> clazz, String ... expression) {
        DelegateWrapper util = DelegateWrapper.getInstance();
        util.delData(clazz, expression);
    }

    public void update() {
        DelegateWrapper.getInstance().updateData(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Object object = LOCK;
        synchronized (object) {
            if (this.thisIsExist()) {
                this.update();
            } else {
                this.insert();
            }
        }
    }

    private boolean thisIsExist() {
        DelegateWrapper util = DelegateWrapper.getInstance();
        return this.rowID != -1L && util.isExist(this.getClass(), this.rowID);
    }

    public static boolean tableExists(Class<DbEntity> clazz) {
        return DelegateWrapper.getInstance().tableExists(clazz);
    }

    public void insert() {
        DelegateWrapper.getInstance().insertData(this);
    }
}

