/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.orm;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.SparseArray;
import com.arialyy.aria.orm.AbsDbWrapper;
import com.arialyy.aria.orm.AbsDelegate;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.orm.SqlUtil;
import com.arialyy.aria.orm.annotation.Many;
import com.arialyy.aria.orm.annotation.One;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class DelegateFind
extends AbsDelegate {
    private final String PARENT_COLUMN_ALIAS = "p";
    private final String CHILD_COLUMN_ALIAS = "c";

    private DelegateFind() {
    }

    private Field[] getOneAndManyField(Class clazz) {
        Field[] om = new Field[2];
        Field[] fields = clazz.getDeclaredFields();
        Field one = null;
        Field many = null;
        boolean hasOne = false;
        boolean hasMany = false;
        for (Field field : fields) {
            if (SqlUtil.isOne(field)) {
                if (hasOne) {
                    ALog.w("AbsDelegate", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u5b9e\u4f53\u4e2d\u6709\u591a\u4e2a@One \u6ce8\u89e3");
                    return null;
                }
                hasOne = true;
                one = field;
            }
            if (!SqlUtil.isMany(field)) continue;
            if (hasMany) {
                ALog.w("AbsDelegate", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u5b9e\u4f53\u4e2d\u6709\u591a\u4e2a@Many \u6ce8\u89e3");
                return null;
            }
            if (!field.getType().isAssignableFrom(List.class)) {
                ALog.w("AbsDelegate", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c@Many \u6ce8\u89e3\u7684\u7c7b\u578b\u4e0d\u662fList");
                return null;
            }
            hasMany = true;
            many = field;
        }
        if (one == null || many == null) {
            ALog.w("AbsDelegate", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u5b9e\u4f53\u4e2d\u6ca1\u6709@One\u6216@Many\u6ce8\u89e3");
            return null;
        }
        if (many.getType() != List.class) {
            ALog.w("AbsDelegate", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c@Many\u6ce8\u89e3\u7684\u5b57\u6bb5\u5fc5\u987b\u662fList");
            return null;
        }
        om[0] = one;
        om[1] = many;
        return om;
    }

    <T extends AbsDbWrapper> List<T> findRelationData(SQLiteDatabase db, Class<T> clazz, String ... expression) {
        return this.exeRelationSql(db, clazz, 1, Integer.MAX_VALUE, expression);
    }

    <T extends AbsDbWrapper> List<T> findRelationData(SQLiteDatabase db, Class<T> clazz, int page, int num, String ... expression) {
        if (page < 1 || num < 1) {
            ALog.w("AbsDelegate", "page\uff0cnum \u5c0f\u4e8e1");
            return null;
        }
        return this.exeRelationSql(db, clazz, page, num, expression);
    }

    private <T extends AbsDbWrapper> List<T> exeRelationSql(SQLiteDatabase db, Class<T> wrapperClazz, int page, int num, String ... expression) {
        db = this.checkDb(db);
        if (SqlUtil.isWrapper(wrapperClazz)) {
            Field[] om = this.getOneAndManyField(wrapperClazz);
            if (om == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            Field one = om[0];
            Field many = om[1];
            try {
                String sql;
                String temp;
                Many m = many.getAnnotation(Many.class);
                Class<?> parentClazz = Class.forName(one.getType().getName());
                Class<?> childClazz = Class.forName(CommonUtil.getListParamType(many).getName());
                SqlUtil.checkOrCreateTable(db, parentClazz);
                SqlUtil.checkOrCreateTable(db, childClazz);
                String pTableName = parentClazz.getSimpleName();
                String cTableName = childClazz.getSimpleName();
                List<Field> pColumn = SqlUtil.getAllNotIgnoreField(parentClazz);
                List<Field> cColumn = SqlUtil.getAllNotIgnoreField(childClazz);
                StringBuilder pSb = new StringBuilder();
                StringBuilder cSb = new StringBuilder();
                if (pColumn != null) {
                    pSb.append(pTableName.concat(".rowid AS ").concat("p").concat("rowid,"));
                    for (Field f : pColumn) {
                        temp = "p".concat(f.getName());
                        pSb.append(pTableName.concat(".").concat(f.getName())).append(" AS ").append(temp).append(",");
                    }
                }
                if (cColumn != null) {
                    pSb.append(cTableName.concat(".rowid AS ").concat("c").concat("rowid,"));
                    for (Field f : cColumn) {
                        temp = "c".concat(f.getName());
                        cSb.append(cTableName.concat(".").concat(f.getName())).append(" AS ").append(temp).append(",");
                    }
                }
                String pColumnAlia = pSb.toString();
                String cColumnAlia = cSb.toString();
                if (!TextUtils.isEmpty((CharSequence)pColumnAlia)) {
                    pColumnAlia = pColumnAlia.substring(0, pColumnAlia.length() - 1);
                }
                if (!TextUtils.isEmpty((CharSequence)cColumnAlia)) {
                    cColumnAlia = cColumnAlia.substring(0, cColumnAlia.length() - 1);
                }
                sb.append("SELECT ");
                if (!TextUtils.isEmpty((CharSequence)pColumnAlia)) {
                    sb.append(pColumnAlia).append(",");
                }
                if (!TextUtils.isEmpty((CharSequence)cColumnAlia)) {
                    sb.append(cColumnAlia);
                }
                if (TextUtils.isEmpty((CharSequence)pColumnAlia) && TextUtils.isEmpty((CharSequence)cColumnAlia)) {
                    sb.append(" * ");
                }
                sb.append(" FROM ").append(pTableName).append(" INNER JOIN ").append(cTableName).append(" ON ").append(pTableName.concat(".").concat(m.parentColumn())).append(" = ").append(cTableName.concat(".").concat(m.entityColumn()));
                if (expression != null && expression.length > 0) {
                    if (!CommonUtil.checkSqlExpression(expression)) {
                        return null;
                    }
                    sb.append(" WHERE ").append(expression[0]).append(" ");
                    sql = sb.toString();
                    sql = sql.replace("?", "%s");
                    Object[] params = new String[expression.length - 1];
                    int len = params.length;
                    for (int i = 0; i < len; ++i) {
                        params[i] = String.format("'%s'", SqlUtil.encodeStr(expression[i + 1]));
                    }
                    sql = String.format(sql, params);
                } else {
                    sql = sb.toString();
                }
                boolean paged = false;
                if (page != -1 && num != -1) {
                    paged = true;
                    sql = sql.concat(String.format(" Group by %s LIMIT %s,%s", pTableName.concat(".").concat(m.parentColumn()), (page - 1) * num, num));
                }
                Cursor cursor = db.rawQuery(sql, null);
                List<T> data = this.newInstanceEntity(wrapperClazz, parentClazz, childClazz, cursor, pColumn, cColumn, paged, db, m.entityColumn(), m.parentColumn());
                this.closeCursor(cursor);
                return data;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            ALog.e("AbsDelegate", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u5b9e\u4f53\u7c7b\u6ca1\u6709\u4f7f\u7528@Wrapper \u6ce8\u89e3");
            return null;
        }
        return null;
    }

    private synchronized <T extends AbsDbWrapper, P extends DbEntity, C extends DbEntity> List<T> newInstanceEntity(Class<T> wrapperClazz, Class<P> parentClazz, Class<C> childClazz, Cursor cursor, List<Field> pColumn, List<Field> cColumn, boolean paged, SQLiteDatabase db, String entityColumn, String parentColumn) {
        ArrayList<AbsDbWrapper> wrappers = new ArrayList<AbsDbWrapper>();
        SparseArray childs = new SparseArray();
        SparseArray parents = new SparseArray();
        try {
            while (cursor.moveToNext()) {
                int pRowId = cursor.getInt(cursor.getColumnIndex("p".concat("rowid")));
                if (childs.get(pRowId) == null) {
                    childs.put(pRowId, new ArrayList());
                    parents.put(pRowId, this.createParent(pRowId, parentClazz, pColumn, cursor));
                }
                if (paged) {
                    List<C> list = this.createChildren(db, childClazz, pColumn, entityColumn, parentColumn, (DbEntity)parents.get(pRowId));
                    if (list == null) continue;
                    ((List)childs.get(pRowId)).addAll(list);
                    continue;
                }
                ((List)childs.get(pRowId)).add(this.createChild(childClazz, cColumn, cursor));
            }
            List<Field> wFields = SqlUtil.getAllNotIgnoreField(wrapperClazz);
            if (wFields == null || wFields.isEmpty()) {
                return null;
            }
            for (int i = 0; i < parents.size(); ++i) {
                int pRowId = parents.keyAt(i);
                AbsDbWrapper wrapper = (AbsDbWrapper)wrapperClazz.newInstance();
                boolean isPSet = false;
                boolean isCSet = false;
                for (Field f : wFields) {
                    if (!isPSet && f.getAnnotation(One.class) != null) {
                        f.set(wrapper, parents.get(pRowId));
                        isPSet = true;
                    }
                    if (isCSet || f.getAnnotation(Many.class) == null) continue;
                    f.set(wrapper, childs.get(pRowId));
                    isCSet = true;
                }
                wrapper.handleConvert();
                wrappers.add(wrapper);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wrappers;
    }

    private <T extends DbEntity> List<T> createChildren(SQLiteDatabase db, Class<T> childClazz, List<Field> pColumn, String entityColumn, String parentColumn, DbEntity parents) throws IllegalAccessException {
        for (Field field : pColumn) {
            field.setAccessible(true);
            if (!field.getName().equals(parentColumn)) continue;
            Object o = field.get(parents);
            if (o instanceof String) {
                o = URLEncoder.encode((String)o);
            }
            return this.findData(db, childClazz, entityColumn + "='" + o + "'");
        }
        return new ArrayList();
    }

    private <T extends DbEntity> T createChild(Class<T> childClazz, List<Field> cColumn, Cursor cursor) throws InstantiationException, IllegalAccessException {
        DbEntity child = (DbEntity)childClazz.newInstance();
        child.rowID = cursor.getInt(cursor.getColumnIndex("c".concat("rowid")));
        for (Field field : cColumn) {
            field.setAccessible(true);
            int columnIndex = cursor.getColumnIndex("c".concat(field.getName()));
            this.setFieldValue(field.getType(), field, columnIndex, cursor, child);
        }
        return (T)child;
    }

    private <T extends DbEntity> T createParent(int rowId, Class<T> parentClazz, List<Field> pColumn, Cursor cursor) throws InstantiationException, IllegalAccessException {
        DbEntity parent = (DbEntity)parentClazz.newInstance();
        parent.rowID = rowId;
        for (Field field : pColumn) {
            field.setAccessible(true);
            int columnIndex = cursor.getColumnIndex("p".concat(field.getName()));
            this.setFieldValue(field.getType(), field, columnIndex, cursor, parent);
        }
        return (T)parent;
    }

    <T extends DbEntity> List<T> findData(SQLiteDatabase db, Class<T> clazz, String ... expression) {
        db = this.checkDb(db);
        if (!CommonUtil.checkSqlExpression(expression)) {
            return null;
        }
        String sql = String.format("SELECT rowid, * FROM %s WHERE %s", CommonUtil.getClassName(clazz), expression[0]);
        String[] params = new String[expression.length - 1];
        try {
            System.arraycopy(expression, 1, params, 0, params.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.exeNormalDataSql(db, clazz, sql, params);
    }

    <T extends DbEntity> List<T> findData(SQLiteDatabase db, Class<T> clazz, int page, int num, String ... expression) {
        if (page < 1 || num < 1) {
            ALog.w("AbsDelegate", "page, bum \u5c0f\u4e8e1");
            return null;
        }
        db = this.checkDb(db);
        if (!CommonUtil.checkSqlExpression(expression)) {
            return null;
        }
        String sql = String.format("SELECT rowid, * FROM %s WHERE %s LIMIT %s,%s", CommonUtil.getClassName(clazz), expression[0], (page - 1) * num, num);
        String[] params = new String[expression.length - 1];
        try {
            System.arraycopy(expression, 1, params, 0, params.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.exeNormalDataSql(db, clazz, sql, params);
    }

    <T extends DbEntity> List<T> findDataByFuzzy(SQLiteDatabase db, Class<T> clazz, String conditions) {
        db = this.checkDb(db);
        if (TextUtils.isEmpty((CharSequence)conditions)) {
            throw new IllegalArgumentException("sql\u8bed\u53e5\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3anull\u6216\"\"");
        }
        if (!conditions.toUpperCase().contains("LIKE")) {
            throw new IllegalArgumentException("sql\u8bed\u53e5\u8868\u8fbe\u5f0f\u672a\u5305\u542bLIEK");
        }
        String sql = String.format("SELECT rowid, * FROM %s, WHERE %s", CommonUtil.getClassName(clazz), conditions);
        return this.exeNormalDataSql(db, clazz, sql, null);
    }

    <T extends DbEntity> List<T> findDataByFuzzy(SQLiteDatabase db, Class<T> clazz, int page, int num, String conditions) {
        if (page < 1 || num < 1) {
            ALog.w("AbsDelegate", "page, bum \u5c0f\u4e8e1");
            return null;
        }
        db = this.checkDb(db);
        if (TextUtils.isEmpty((CharSequence)conditions)) {
            throw new IllegalArgumentException("sql\u8bed\u53e5\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3anull\u6216\"\"");
        }
        if (!conditions.toUpperCase().contains("LIKE")) {
            throw new IllegalArgumentException("sql\u8bed\u53e5\u8868\u8fbe\u5f0f\u672a\u5305\u542bLIEK");
        }
        String sql = String.format("SELECT rowid, * FROM %s WHERE %s LIMIT %s,%s", CommonUtil.getClassName(clazz), conditions, (page - 1) * num, num);
        return this.exeNormalDataSql(db, clazz, sql, null);
    }

    <T extends DbEntity> List<T> findAllData(SQLiteDatabase db, Class<T> clazz) {
        db = this.checkDb(db);
        String sql = String.format("SELECT rowid, * FROM %s", CommonUtil.getClassName(clazz));
        return this.exeNormalDataSql(db, clazz, sql, null);
    }

    private <T extends DbEntity> List<T> exeNormalDataSql(SQLiteDatabase db, Class<T> clazz, String sql, String[] selectionArgs) {
        Cursor cursor;
        SqlUtil.checkOrCreateTable(db, clazz);
        if (selectionArgs != null) {
            String[] temp = new String[selectionArgs.length];
            int i = 0;
            for (String arg : selectionArgs) {
                temp[i] = SqlUtil.encodeStr(arg);
                ++i;
            }
            cursor = db.rawQuery(sql, temp);
        } else {
            cursor = db.rawQuery(sql, null);
        }
        List<T> data = cursor.getCount() > 0 ? this.newInstanceEntity(clazz, cursor) : null;
        this.closeCursor(cursor);
        return data;
    }

    private synchronized <T extends DbEntity> List<T> newInstanceEntity(Class<T> clazz, Cursor cursor) {
        List<Field> fields = CommonUtil.getAllFields(clazz);
        ArrayList<DbEntity> entitys = new ArrayList<DbEntity>();
        if (fields != null && fields.size() > 0) {
            try {
                while (cursor.moveToNext()) {
                    DbEntity entity = (DbEntity)clazz.newInstance();
                    String primaryName = "";
                    for (Field field : fields) {
                        int column;
                        field.setAccessible(true);
                        if (SqlUtil.isIgnore(field)) continue;
                        Class<?> type = field.getType();
                        if (SqlUtil.isPrimary(field) && (type == Integer.TYPE || type == Integer.class)) {
                            primaryName = field.getName();
                        }
                        if ((column = cursor.getColumnIndex(field.getName())) == -1) continue;
                        this.setFieldValue(type, field, column, cursor, entity);
                    }
                    entity.rowID = cursor.getInt(cursor.getColumnIndex(TextUtils.isEmpty((CharSequence)primaryName) ? "rowid" : primaryName));
                    entitys.add(entity);
                }
                this.closeCursor(cursor);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return entitys;
    }

    private void setFieldValue(Class type, Field field, int columnIndex, Cursor cursor, DbEntity entity) throws IllegalAccessException {
        String value;
        if (cursor == null || cursor.isClosed()) {
            ALog.e("AbsDelegate", "cursor\u6ca1\u6709\u521d\u59cb\u5316");
            return;
        }
        if (type == String.class) {
            String temp = cursor.getString(columnIndex);
            if (!TextUtils.isEmpty((CharSequence)temp)) {
                field.set(entity, URLDecoder.decode(temp));
            }
        } else if (type == Integer.TYPE || type == Integer.class) {
            field.setInt(entity, cursor.getInt(columnIndex));
        } else if (type == Float.TYPE || type == Float.class) {
            field.setFloat(entity, cursor.getFloat(columnIndex));
        } else if (type == Double.TYPE || type == Double.class) {
            field.setDouble(entity, cursor.getDouble(columnIndex));
        } else if (type == Long.TYPE || type == Long.class) {
            field.setLong(entity, cursor.getLong(columnIndex));
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            String temp = cursor.getString(columnIndex);
            if (TextUtils.isEmpty((CharSequence)temp)) {
                field.setBoolean(entity, false);
            } else {
                field.setBoolean(entity, !temp.equalsIgnoreCase("false"));
            }
        } else if (type == java.util.Date.class || type == Date.class) {
            field.set(entity, new java.util.Date(URLDecoder.decode(cursor.getString(columnIndex))));
        } else if (type == byte[].class) {
            field.set(entity, cursor.getBlob(columnIndex));
        } else if (type == Map.class) {
            String temp = cursor.getString(columnIndex);
            if (!TextUtils.isEmpty((CharSequence)temp)) {
                field.set(entity, SqlUtil.str2Map(URLDecoder.decode(temp)));
            }
        } else if (type == List.class && !TextUtils.isEmpty((CharSequence)(value = cursor.getString(columnIndex)))) {
            field.set(entity, SqlUtil.str2List(URLDecoder.decode(value), field));
        }
    }

    int[] getRowId(SQLiteDatabase db, Class clazz) {
        db = this.checkDb(db);
        Cursor cursor = db.rawQuery("SELECT rowid, * FROM " + CommonUtil.getClassName(clazz), null);
        int[] ids = new int[cursor.getCount()];
        int i = 0;
        while (cursor.moveToNext()) {
            ids[i] = cursor.getInt(cursor.getColumnIndex("rowid"));
            ++i;
        }
        cursor.close();
        return ids;
    }

    int getRowId(SQLiteDatabase db, Class clazz, Object[] wheres, Object[] values) {
        db = this.checkDb(db);
        if (wheres.length <= 0 || values.length <= 0) {
            ALog.e("AbsDelegate", "\u8bf7\u8f93\u5165\u5220\u9664\u6761\u4ef6");
            return -1;
        }
        if (wheres.length != values.length) {
            ALog.e("AbsDelegate", "groupHash \u548c vaule \u957f\u5ea6\u4e0d\u76f8\u7b49");
            return -1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT rowid FROM ").append(CommonUtil.getClassName(clazz)).append(" WHERE ");
        int i = 0;
        for (Object where : wheres) {
            sb.append(where).append("=").append("'").append(values[i]).append("'");
            sb.append(i >= wheres.length - 1 ? "" : ",");
            ++i;
        }
        Cursor c = db.rawQuery(sb.toString(), null);
        int id = c.getColumnIndex("rowid");
        c.close();
        return id;
    }

    <T extends DbEntity> boolean itemExist(SQLiteDatabase db, Class<T> clazz, long rowId) {
        return this.itemExist(db, CommonUtil.getClassName(clazz), rowId);
    }

    boolean itemExist(SQLiteDatabase db, String tableName, long rowId) {
        String sql;
        Cursor cursor = (db = this.checkDb(db)).rawQuery(sql = "SELECT rowid FROM " + tableName + " WHERE rowid=" + rowId, null);
        boolean isExist = cursor.getCount() > 0;
        cursor.close();
        return isExist;
    }
}

