/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.orm;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.arialyy.aria.orm.AbsDelegate;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.orm.SqlUtil;
import com.arialyy.aria.orm.annotation.Primary;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

class DelegateUpdate
extends AbsDelegate {
    private DelegateUpdate() {
    }

    synchronized <T extends DbEntity> void delData(SQLiteDatabase db, Class<T> clazz, String ... expression) {
        SqlUtil.checkOrCreateTable(db, clazz);
        db = this.checkDb(db);
        if (!CommonUtil.checkSqlExpression(expression)) {
            return;
        }
        String sql = "DELETE FROM " + CommonUtil.getClassName(clazz) + " WHERE " + expression[0] + " ";
        sql = sql.replace("?", "%s");
        Object[] params = new String[expression.length - 1];
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            params[i] = String.format("'%s'", SqlUtil.encodeStr(expression[i + 1]));
        }
        sql = String.format(sql, params);
        db.execSQL(sql);
    }

    synchronized void updateData(SQLiteDatabase db, DbEntity dbEntity) {
        SqlUtil.checkOrCreateTable(db, dbEntity.getClass());
        db = this.checkDb(db);
        ContentValues values = this.createValues(dbEntity);
        if (values != null) {
            db.update(CommonUtil.getClassName(dbEntity), values, "rowid=?", new String[]{String.valueOf(dbEntity.rowID)});
        } else {
            ALog.e("AbsDelegate", "\u66f4\u65b0\u8bb0\u5f55\u5931\u8d25\uff0c\u8bb0\u5f55\u6ca1\u6709\u5c5e\u6027\u5b57\u6bb5");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized <T extends DbEntity> void updateManyData(SQLiteDatabase db, List<T> dbEntities) {
        db = this.checkDb(db);
        db.beginTransaction();
        try {
            Class<?> oldClazz = null;
            String table = null;
            for (DbEntity entity : dbEntities) {
                ContentValues value;
                if (oldClazz == null || oldClazz != entity.getClass() || table == null) {
                    oldClazz = entity.getClass();
                    table = CommonUtil.getClassName(oldClazz);
                }
                if ((value = this.createValues(entity)) == null) {
                    ALog.e("AbsDelegate", "\u66f4\u65b0\u8bb0\u5f55\u5931\u8d25\uff0c\u8bb0\u5f55\u6ca1\u6709\u5c5e\u6027\u5b57\u6bb5");
                    continue;
                }
                db.update(table, value, "rowid=?", new String[]{String.valueOf(entity.rowID)});
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized <T extends DbEntity> void insertManyData(SQLiteDatabase db, List<T> dbEntities) {
        db = this.checkDb(db);
        db.beginTransaction();
        try {
            Class<?> oldClazz = null;
            String table = null;
            for (DbEntity entity : dbEntities) {
                ContentValues value;
                if (oldClazz == null || oldClazz != entity.getClass() || table == null) {
                    oldClazz = entity.getClass();
                    table = CommonUtil.getClassName(oldClazz);
                    SqlUtil.checkOrCreateTable(db, oldClazz);
                }
                if ((value = this.createValues(entity)) == null) {
                    ALog.e("AbsDelegate", "\u4fdd\u5b58\u8bb0\u5f55\u5931\u8d25\uff0c\u8bb0\u5f55\u6ca1\u6709\u5c5e\u6027\u5b57\u6bb5");
                    continue;
                }
                entity.rowID = db.insert(table, null, value);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
    }

    synchronized void insertData(SQLiteDatabase db, DbEntity dbEntity) {
        SqlUtil.checkOrCreateTable(db, dbEntity.getClass());
        db = this.checkDb(db);
        ContentValues values = this.createValues(dbEntity);
        if (values != null) {
            dbEntity.rowID = db.insert(CommonUtil.getClassName(dbEntity), null, values);
        } else {
            ALog.e("AbsDelegate", "\u4fdd\u5b58\u8bb0\u5f55\u5931\u8d25\uff0c\u8bb0\u5f55\u6ca1\u6709\u5c5e\u6027\u5b57\u6bb5");
        }
    }

    private ContentValues createValues(DbEntity dbEntity) {
        List<Field> fields = CommonUtil.getAllFields(dbEntity.getClass());
        if (fields.size() > 0) {
            ContentValues values = new ContentValues();
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    if (this.isIgnore(dbEntity, field)) continue;
                    String value = null;
                    Class<?> type = field.getType();
                    if (type == Map.class && SqlUtil.checkMap(field)) {
                        value = SqlUtil.map2Str((Map)field.get(dbEntity));
                    } else if (type == List.class && SqlUtil.checkList(field)) {
                        value = SqlUtil.list2Str(dbEntity, field);
                    } else {
                        Object obj = field.get(dbEntity);
                        if (obj != null) {
                            value = field.get(dbEntity).toString();
                        }
                    }
                    values.put(field.getName(), SqlUtil.encodeStr(value));
                }
                return values;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean isIgnore(Object obj, Field field) throws IllegalAccessException {
        if (SqlUtil.isIgnore(field)) {
            return true;
        }
        Object value = field.get(obj);
        if (value == null) {
            return true;
        }
        if (value instanceof String && TextUtils.isEmpty((CharSequence)String.valueOf(value))) {
            return true;
        }
        if (value instanceof List && ((List)value).size() == 0) {
            return true;
        }
        if (value instanceof Map && ((Map)value).size() == 0) {
            return true;
        }
        if (SqlUtil.isPrimary(field)) {
            Primary p = field.getAnnotation(Primary.class);
            return p.autoincrement();
        }
        return false;
    }
}

