/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.orm;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.M3U8Entity;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.orm.DBConfig;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.orm.SqlUtil;
import com.arialyy.aria.util.ALog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SqlHelper
extends SQLiteOpenHelper {
    private static final String TAG = "SqlHelper";
    private static volatile SqlHelper INSTANCE = null;
    private static boolean mainTmpDirSet = false;
    private Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static synchronized SqlHelper init(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<SqlHelper> clazz = SqlHelper.class;
        synchronized (SqlHelper.class) {
            INSTANCE = new SqlHelper(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    static SqlHelper getInstance() {
        return INSTANCE;
    }

    private SqlHelper(Context context) {
        super(context, DBConfig.DB_NAME, null, DBConfig.VERSION);
        this.mContext = context;
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
    }

    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);
        if (Build.VERSION.SDK_INT >= 16) {
            db.setForeignKeyConstraintsEnabled(true);
        } else {
            db.execSQL("PRAGMA foreign_keys=ON;");
        }
    }

    public void onCreate(SQLiteDatabase db) {
        Set<String> tables = DBConfig.mapping.keySet();
        for (String tableName : tables) {
            Class<? extends DbEntity> clazz = DBConfig.mapping.get(tableName);
            if (SqlUtil.tableExists(db, clazz)) continue;
            SqlUtil.createTable(db, clazz);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < newVersion) {
            if (oldVersion < 31) {
                this.handleLowAriaUpdate(db);
            } else if (oldVersion < 45) {
                this.handle360AriaUpdate(db);
            } else if (oldVersion < 51) {
                this.handle365Update(db);
            } else if (oldVersion < 53) {
                this.handle366Update(db);
            } else {
                this.handleDbUpdate(db, null);
            }
            if (newVersion == 57) {
                this.addTaskRecordType(db);
            }
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion > newVersion) {
            this.handleDbUpdate(db, null);
        }
    }

    SQLiteDatabase getDb() {
        SQLiteDatabase db;
        if (Build.VERSION.SDK_INT >= 28) {
            SQLiteDatabase.OpenParams params = new SQLiteDatabase.OpenParams.Builder().setOpenFlags(0x10000010).build();
            this.setOpenParams(params);
            db = this.getWritableDatabase();
        } else {
            File dbFile = this.mContext.getDatabasePath(DBConfig.DB_NAME);
            if (!dbFile.exists()) {
                db = this.getWritableDatabase();
            } else {
                db = this.getReadableDatabase();
                db.close();
                db = SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)0x10000010);
            }
        }
        db.enableWriteAheadLogging();
        return db;
    }

    public SQLiteDatabase getWritableDatabase() {
        if (!mainTmpDirSet) {
            this.createDbCacheDir();
            return super.getWritableDatabase();
        }
        return super.getWritableDatabase();
    }

    public SQLiteDatabase getReadableDatabase() {
        if (!mainTmpDirSet) {
            this.createDbCacheDir();
            return super.getReadableDatabase();
        }
        return super.getReadableDatabase();
    }

    private void createDbCacheDir() {
        String cacheDir = this.mContext.getCacheDir().getPath() + "/AriaDbCacheDir";
        File cacheFile = new File(cacheDir);
        if (!cacheFile.exists()) {
            boolean rs = cacheFile.mkdirs();
            ALog.d(TAG, rs + "");
        }
        super.getReadableDatabase().execSQL("PRAGMA temp_store_directory = '" + cacheDir + "'");
        mainTmpDirSet = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDbUpdate(SQLiteDatabase db, Map<String, Map<String, String>> modifyColumns) {
        if (db == null) {
            ALog.e(TAG, "db \u4e3a null");
            return;
        }
        if (!db.isOpen()) {
            ALog.e(TAG, "db\u5df2\u5173\u95ed");
            return;
        }
        try {
            db.beginTransaction();
            Set<String> tables = DBConfig.mapping.keySet();
            for (String tableName : tables) {
                Class<? extends DbEntity> clazz = DBConfig.mapping.get(tableName);
                if (SqlUtil.tableExists(db, clazz)) {
                    Cursor columnC = db.rawQuery(String.format("PRAGMA table_info(%s)", tableName), null);
                    List<String> newTabColumns = SqlUtil.getColumns(clazz);
                    ArrayList<String> oldTabColumns = new ArrayList<String>();
                    while (columnC.moveToNext()) {
                        String columnName = columnC.getString(columnC.getColumnIndex("name"));
                        oldTabColumns.add(columnName);
                    }
                    columnC.close();
                    List<String> newAddColum = this.getNewColumn(newTabColumns, oldTabColumns);
                    Map<String, String> modifyMap = null;
                    if (modifyColumns != null && (modifyMap = modifyColumns.get(tableName)) != null) {
                        Iterator<String> it = newAddColum.iterator();
                        while (it.hasNext()) {
                            String s = it.next();
                            if (modifyMap.get(s) == null) continue;
                            it.remove();
                        }
                    }
                    if (newAddColum.size() > 0) {
                        String sql = "ALTER TABLE %s ADD COLUMN %s %s";
                        for (String nc : newAddColum) {
                            String temp = String.format(sql, tableName, nc, SqlUtil.getColumnTypeByFieldName(clazz, nc));
                            ALog.d(TAG, "\u6dfb\u52a0\u8868\u5b57\u6bb5\u7684sql\uff1a" + temp);
                            db.execSQL(temp);
                        }
                    }
                    String alertSql = String.format("ALTER TABLE %s RENAME TO %s_temp", tableName, tableName);
                    db.execSQL(alertSql);
                    SqlUtil.createTable(db, clazz);
                    String sql = String.format("SELECT COUNT(*) FROM %s_temp", tableName);
                    Cursor cursor = db.rawQuery(sql, null);
                    cursor.moveToFirst();
                    long count = cursor.getLong(0);
                    cursor.close();
                    if (count > 0L) {
                        List<String> diffTab = this.getDiffColumn(newTabColumns, oldTabColumns);
                        StringBuilder params = new StringBuilder();
                        if (modifyColumns != null) {
                            modifyMap = modifyColumns.get(tableName);
                        }
                        for (String column : oldTabColumns) {
                            if (!diffTab.isEmpty() && diffTab.contains(column) && (modifyMap == null || !modifyMap.containsKey(column))) continue;
                            params.append(column).append(",");
                        }
                        String oldParamStr = params.toString();
                        String newParamStr = oldParamStr = oldParamStr.substring(0, oldParamStr.length() - 1);
                        if (modifyMap != null && !modifyMap.isEmpty()) {
                            Set<String> keys = modifyMap.keySet();
                            for (String key : keys) {
                                if (!newParamStr.contains(key)) continue;
                                newParamStr = newParamStr.replace(key, modifyMap.get(key));
                            }
                        }
                        String insertSql = String.format("INSERT INTO %s (%s) SELECT %s FROM %s_temp", tableName, newParamStr, oldParamStr, tableName);
                        ALog.d(TAG, "\u6062\u590d\u6570\u636e\u7684sql\uff1a" + insertSql);
                        db.execSQL(insertSql);
                    }
                    SqlUtil.dropTable(db, tableName + "_temp");
                    continue;
                }
                SqlUtil.createTable(db, clazz);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
    }

    private List<String> getDiffColumn(List<String> newTab, List<String> oldTab) {
        ArrayList<String> temp = new ArrayList<String>(oldTab);
        temp.removeAll(newTab);
        return temp;
    }

    private List<String> getNewColumn(List<String> newTab, List<String> oldTab) {
        ArrayList<String> temp = new ArrayList<String>(newTab);
        temp.removeAll(oldTab);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTaskRecordType(SQLiteDatabase db) {
        try {
            SqlUtil.checkOrCreateTable(db, ThreadRecord.class);
            SqlUtil.checkOrCreateTable(db, TaskRecord.class);
            SqlUtil.checkOrCreateTable(db, UploadEntity.class);
            SqlUtil.checkOrCreateTable(db, DownloadEntity.class);
            db.beginTransaction();
            String dSql = "SELECT downloadPath, url FROM DownloadEntity";
            Cursor c = db.rawQuery(dSql, null);
            while (c.moveToNext()) {
                int type;
                String filePath = c.getString(0);
                String url = c.getString(1);
                if (url.startsWith("ftp") || url.startsWith("sftp")) {
                    type = 3;
                } else if (SqlUtil.tableExists(db, M3U8Entity.class)) {
                    String temp;
                    Cursor m3u8c = db.rawQuery("SELECT isLive FROM M3U8Entity WHERE filePath=\"" + SqlUtil.encodeStr(filePath) + "\"", null);
                    type = m3u8c.moveToNext() ? (!TextUtils.isEmpty((CharSequence)(temp = m3u8c.getString(0))) && Boolean.valueOf(temp) != false ? 8 : 7) : 1;
                    m3u8c.close();
                } else {
                    type = 1;
                }
                db.execSQL("UPDATE DownloadEntity SET taskType=? WHERE downloadPath=?", new Object[]{type, filePath});
                db.execSQL("UPDATE TaskRecord SET taskType=? WHERE filePath=?", new Object[]{type, filePath});
                db.execSQL("UPDATE ThreadRecord SET threadType=? WHERE taskKey=?", new Object[]{type, filePath});
            }
            c.close();
            String uSql = "SELECT filePath, url FROM UploadEntity";
            c = db.rawQuery(uSql, null);
            while (c.moveToNext()) {
                String filePath = c.getString(c.getColumnIndex("filePath"));
                String url = c.getString(c.getColumnIndex("url"));
                int type = url.startsWith("ftp") || url.startsWith("sftp") ? 3 : 1;
                db.execSQL("UPDATE UploadEntity SET taskType=? WHERE filePath=?", new Object[]{type, filePath});
                db.execSQL("UPDATE TaskRecord SET taskType=? WHERE filePath=?", new Object[]{type, filePath});
                db.execSQL("UPDATE ThreadRecord SET threadType=? WHERE taskKey=?", new Object[]{type, filePath});
            }
            c.close();
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
        }
    }

    private void delRepeatThreadRecord(SQLiteDatabase db) {
        SqlUtil.checkOrCreateTable(db, ThreadRecord.class);
        String repeatSql = "DELETE FROM ThreadRecord WHERE (rowid) IN (SELECT rowid FROM ThreadRecord GROUP BY taskKey, threadId, endLocation HAVING COUNT(*) > 1) AND rowid NOT IN (SELECT MIN(rowid) FROM ThreadRecord GROUP BY taskKey, threadId, endLocation HAVING COUNT(*)> 1)";
        ALog.d(TAG, repeatSql);
        db.execSQL(repeatSql);
    }

    private void handle366Update(SQLiteDatabase db) {
        HashMap<String, Map<String, String>> modifyMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> threadRecordModify = new HashMap<String, String>();
        threadRecordModify.put("key", "taskKey");
        modifyMap.put("ThreadRecord", threadRecordModify);
        this.handleDbUpdate(db, modifyMap);
        this.delRepeatThreadRecord(db);
    }

    private void handle365Update(SQLiteDatabase db) {
        SqlUtil.checkOrCreateTable(db, ThreadRecord.class);
        db.execSQL("UPDATE ThreadRecord SET threadId=0 WHERE threadId=-1");
        HashMap<String, Map<String, String>> modifyMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> threadRecordModify = new HashMap<String, String>();
        threadRecordModify.put("key", "taskKey");
        modifyMap.put("ThreadRecord", threadRecordModify);
        this.handleDbUpdate(db, modifyMap);
        this.delRepeatThreadRecord(db);
    }

    private void handle360AriaUpdate(SQLiteDatabase db) {
        String[] taskTables;
        for (String taskTable : taskTables = new String[]{"UploadTaskEntity", "DownloadTaskEntity", "DownloadGroupTaskEntity"}) {
            if (!SqlUtil.tableExists(db, taskTable)) continue;
            SqlUtil.dropTable(db, taskTable);
        }
        HashMap<String, Map<String, String>> modifyMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> entityModify = new HashMap<String, String>();
        entityModify.put("groupName", "groupHash");
        modifyMap.put("DownloadEntity", entityModify);
        modifyMap.put("DownloadGroupEntity", entityModify);
        HashMap<String, String> taskRecordModify = new HashMap<String, String>();
        taskRecordModify.put("dGroupName", "dGroupHash");
        modifyMap.put("TaskRecord", taskRecordModify);
        HashMap<String, String> threadRecordModify = new HashMap<String, String>();
        threadRecordModify.put("key", "taskKey");
        modifyMap.put("ThreadRecord", threadRecordModify);
        this.handleDbUpdate(db, modifyMap);
        this.delRepeatThreadRecord(db);
    }

    private void handleLowAriaUpdate(SQLiteDatabase db) {
        String[] taskTables;
        for (String string : taskTables = new String[]{"UploadTaskEntity", "DownloadTaskEntity", "DownloadGroupTaskEntity"}) {
            if (!SqlUtil.tableExists(db, string)) continue;
            SqlUtil.dropTable(db, string);
        }
        String[] tables = new String[]{"DownloadEntity", "DownloadGroupEntity"};
        String[] keys = new String[]{"downloadPath", "groupName"};
        int i = 0;
        for (String tableName : tables) {
            if (!SqlUtil.tableExists(db, tableName)) continue;
            String pColumn = keys[i];
            String nullSql = String.format("DELETE FROM %s WHERE %s='' OR %s IS NULL", tableName, pColumn, pColumn);
            ALog.d(TAG, nullSql);
            db.execSQL(nullSql);
            String repeatSql = String.format("DELETE FROM %s WHERE %s IN(SELECT %s FROM %s GROUP BY %s HAVING COUNT(%s) > 1)", tableName, pColumn, pColumn, tableName, pColumn, pColumn);
            ALog.d(TAG, repeatSql);
            db.execSQL(repeatSql);
            ++i;
        }
        HashMap<String, Map<String, String>> hashMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> dEntityModifyMap = new HashMap<String, String>();
        dEntityModifyMap.put("groupName", "groupHash");
        dEntityModifyMap.put("downloadUrl", "url");
        dEntityModifyMap.put("isDownloadComplete", "isComplete");
        hashMap.put("DownloadEntity", dEntityModifyMap);
        HashMap<String, String> dGEntityModifyMap = new HashMap<String, String>();
        dGEntityModifyMap.put("groupName", "groupHash");
        hashMap.put("DownloadGroupEntity", dGEntityModifyMap);
        this.handleDbUpdate(db, hashMap);
    }
}

