/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.orm;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.arialyy.aria.orm.AbsDbWrapper;
import com.arialyy.aria.orm.AbsDelegate;
import com.arialyy.aria.orm.ActionPolicy;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.orm.SqlHelper;
import com.arialyy.aria.orm.annotation.Default;
import com.arialyy.aria.orm.annotation.Foreign;
import com.arialyy.aria.orm.annotation.Ignore;
import com.arialyy.aria.orm.annotation.Many;
import com.arialyy.aria.orm.annotation.NoNull;
import com.arialyy.aria.orm.annotation.One;
import com.arialyy.aria.orm.annotation.Primary;
import com.arialyy.aria.orm.annotation.Unique;
import com.arialyy.aria.orm.annotation.Wrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URLEncoder;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class SqlUtil {
    private static final String TAG = CommonUtil.getClassName("SqlUtil");

    SqlUtil() {
    }

    static void checkOrCreateTable(SQLiteDatabase db, Class<? extends DbEntity> clazz) {
        if (!SqlUtil.tableExists(db, clazz)) {
            SqlUtil.createTable(db, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeCursor(Cursor cursor) {
        Class<AbsDelegate> clazz = AbsDelegate.class;
        synchronized (AbsDelegate.class) {
            if (cursor != null && !cursor.isClosed()) {
                try {
                    cursor.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static boolean tableExists(SQLiteDatabase db, Class<? extends DbEntity> clazz) {
        return SqlUtil.tableExists(db, CommonUtil.getClassName(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean tableExists(SQLiteDatabase db, String tableName) {
        db = SqlUtil.checkDb(db);
        Cursor cursor = null;
        try {
            int count;
            String sql = String.format("SELECT COUNT(*) FROM sqlite_master WHERE type='table' AND name='%s'", tableName);
            cursor = db.rawQuery(sql, null);
            if (cursor != null && cursor.moveToNext() && (count = cursor.getInt(0)) > 0) {
                boolean bl = true;
                SqlUtil.closeCursor(cursor);
                return bl;
            }
            SqlUtil.closeCursor(cursor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SqlUtil.closeCursor(cursor);
        }
        return false;
    }

    static boolean checkList(Field list) {
        Class t = CommonUtil.getListParamType(list);
        if (t == String.class) {
            return true;
        }
        ALog.d(TAG, "map\u53c2\u6570\u9519\u8bef\uff0c\u652f\u6301List<String>\u7684\u53c2\u6570\u5b57\u6bb5");
        return false;
    }

    static boolean checkMap(Field map) {
        Class[] ts = CommonUtil.getMapParamType(map);
        if (ts != null && ts[0] != null && ts[1] != null && ts[0] == String.class && ts[1] == String.class) {
            return true;
        }
        ALog.d(TAG, "map\u53c2\u6570\u9519\u8bef\uff0c\u652f\u6301Map<String,String>\u7684\u53c2\u6570\u5b57\u6bb5");
        return false;
    }

    static void dropTable(SQLiteDatabase db, String tableName) {
        db = SqlUtil.checkDb(db);
        String deleteSQL = String.format("DROP TABLE IF EXISTS %s", tableName);
        db.execSQL(deleteSQL);
    }

    static void clean(SQLiteDatabase db, Class<? extends DbEntity> clazz) {
        db = SqlUtil.checkDb(db);
        String tableName = CommonUtil.getClassName(clazz);
        if (SqlUtil.tableExists(db, clazz)) {
            String sql = "DELETE FROM " + tableName;
            db.execSQL(sql);
        }
    }

    static boolean checkDataExist(SQLiteDatabase db, Class<? extends DbEntity> clazz, String ... expression) {
        db = SqlUtil.checkDb(db);
        if (!CommonUtil.checkSqlExpression(expression)) {
            return false;
        }
        String sql = String.format("SELECT rowid, * FROM %s WHERE %s ", CommonUtil.getClassName(clazz), expression[0]);
        sql = sql.replace("?", "%s");
        Object[] params = new String[expression.length - 1];
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            params[i] = String.format("'%s'", SqlUtil.encodeStr(expression[i + 1]));
        }
        Cursor cursor = db.rawQuery(sql = String.format(sql, params), null);
        boolean isExist = cursor.getCount() > 0;
        SqlUtil.closeCursor(cursor);
        return isExist;
    }

    static List<String> getColumns(Class<? extends DbEntity> clazz) {
        ArrayList<String> columns = new ArrayList<String>();
        List<Field> fields = CommonUtil.getAllFields(clazz);
        for (Field field : fields) {
            field.setAccessible(true);
            if (SqlUtil.isIgnore(field)) continue;
            columns.add(field.getName());
        }
        return columns;
    }

    static SQLiteDatabase checkDb(SQLiteDatabase db) {
        if (db == null || !db.isOpen()) {
            db = SqlHelper.getInstance().getDb();
        }
        return db;
    }

    static void createTable(SQLiteDatabase db, Class<? extends DbEntity> clazz) {
        db = SqlUtil.checkDb(db);
        List<Field> fields = CommonUtil.getAllFields(clazz);
        if (fields != null && fields.size() > 0) {
            ArrayList<Field> foreignArray = new ArrayList<Field>();
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE IF NOT EXISTS ").append(CommonUtil.getClassName(clazz)).append(" (");
            for (Field field : fields) {
                Default d;
                Class<?> type;
                String columnType;
                field.setAccessible(true);
                if (SqlUtil.isIgnore(field) || (columnType = SqlUtil.getColumnType(type = field.getType())) == null) continue;
                sb.append(field.getName());
                sb.append(" ").append(columnType);
                if (SqlUtil.isPrimary(field)) {
                    Primary pk = field.getAnnotation(Primary.class);
                    sb.append(" PRIMARY KEY");
                    if (pk.autoincrement() && (type == Integer.TYPE || type == Integer.class)) {
                        sb.append(" AUTOINCREMENT");
                    }
                }
                if (SqlUtil.isForeign(field)) {
                    foreignArray.add(field);
                }
                if (SqlUtil.isNoNull(field)) {
                    sb.append(" NOT NULL");
                }
                if (SqlUtil.isDefault(field) && !TextUtils.isEmpty((CharSequence)(d = field.getAnnotation(Default.class)).value())) {
                    sb.append(" ERROR ").append("'").append(d.value()).append("'");
                }
                if (SqlUtil.isUnique(field)) {
                    sb.append(" UNIQUE");
                }
                sb.append(",");
            }
            for (Field field : foreignArray) {
                Foreign foreign = field.getAnnotation(Foreign.class);
                sb.append("FOREIGN KEY (").append(field.getName()).append(") REFERENCES ").append(CommonUtil.getClassName(foreign.parent())).append("(").append(foreign.column()).append(")");
                ActionPolicy update = foreign.onUpdate();
                ActionPolicy delete = foreign.onDelete();
                if (update != ActionPolicy.NO_ACTION) {
                    sb.append(" ON UPDATE ").append(update.function);
                }
                if (delete != ActionPolicy.NO_ACTION) {
                    sb.append(" ON DELETE ").append(update.function);
                }
                sb.append(",");
            }
            String str = sb.toString();
            str = str.substring(0, str.length() - 1) + ");";
            ALog.d(TAG, "\u521b\u5efa\u8868\u7684sql\uff1a" + str);
            db.execSQL(str);
        }
    }

    static String getColumnTypeByFieldName(Class tabClass, String fieldName) {
        List<Field> fields = CommonUtil.getAllFields(tabClass);
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return SqlUtil.getColumnType(field.getType());
        }
        return null;
    }

    static String getColumnType(Class fieldtype) {
        if (fieldtype == String.class || fieldtype.isEnum()) {
            return "VARCHAR";
        }
        if (fieldtype == Integer.TYPE || fieldtype == Integer.class) {
            return "INTEGER";
        }
        if (fieldtype == Float.TYPE || fieldtype == Float.class) {
            return "FLOAT";
        }
        if (fieldtype == Double.TYPE || fieldtype == Double.class) {
            return "DOUBLE";
        }
        if (fieldtype == Long.TYPE || fieldtype == Long.class) {
            return "BIGINT";
        }
        if (fieldtype == Boolean.TYPE || fieldtype == Boolean.class) {
            return "BOOLEAN";
        }
        if (fieldtype == java.util.Date.class || fieldtype == Date.class) {
            return "DATA";
        }
        if (fieldtype == Byte.TYPE || fieldtype == Byte.class) {
            return "BLOB";
        }
        if (fieldtype == Map.class || fieldtype == List.class) {
            return "TEXT";
        }
        return null;
    }

    static String encodeStr(String str) {
        str = str.replaceAll("\\+", "%2B");
        return URLEncoder.encode(str);
    }

    static String getPrimaryName(Class<? extends DbEntity> clazz) {
        List<Field> fields = CommonUtil.getAllFields(clazz);
        if (fields != null && !fields.isEmpty()) {
            for (Field field : fields) {
                field.setAccessible(true);
                if (!SqlUtil.isPrimary(field)) continue;
                String column = field.getName();
                return column;
            }
        }
        return null;
    }

    static List<Field> getAllNotIgnoreField(Class clazz) {
        List<Field> fields = CommonUtil.getAllFields(clazz);
        ArrayList<Field> temp = new ArrayList<Field>();
        if (fields != null && fields.size() > 0) {
            for (Field f : fields) {
                f.setAccessible(true);
                if (SqlUtil.isIgnore(f)) continue;
                temp.add(f);
            }
            return temp;
        }
        return null;
    }

    static String list2Str(DbEntity dbEntity, Field field) throws IllegalAccessException {
        List list = (List)field.get(dbEntity);
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object aList : list) {
            sb.append(aList).append("$$");
        }
        return sb.toString();
    }

    static List str2List(String str, Field field) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        String[] datas = str.split("\\$\\$");
        ArrayList<Object> list = new ArrayList<Object>();
        Class clazz = CommonUtil.getListParamType(field);
        if (clazz != null) {
            String type = clazz.getName();
            for (String data : datas) {
                list.add(SqlUtil.checkData(type, data));
            }
        }
        return list;
    }

    static Map<String, String> str2Map(String str) {
        String[] element;
        HashMap<String, String> map = new HashMap<String, String>();
        if (TextUtils.isEmpty((CharSequence)str)) {
            return map;
        }
        boolean isDecode = false;
        if (str.endsWith("_&_decode_&_")) {
            isDecode = true;
            str = str.substring(0, str.length() - 12);
        }
        for (String data : element = str.split(",")) {
            String[] s = data.split("\\$");
            if (isDecode) {
                map.put(CommonUtil.decryptBASE64(s[0]), CommonUtil.decryptBASE64(s[1]));
                continue;
            }
            map.put(s[0], s[1]);
        }
        return map;
    }

    static String map2Str(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            sb.append(CommonUtil.encryptBASE64(key)).append("$").append(CommonUtil.encryptBASE64(map.get(key))).append(",");
        }
        String str = sb.toString();
        String string = str = TextUtils.isEmpty((CharSequence)str) ? str : str.substring(0, str.length() - 1);
        if (map.size() != 0) {
            str = str + "_&_decode_&_";
        }
        return str;
    }

    static boolean isIgnore(Field field) {
        Ignore ignore = field.getAnnotation(Ignore.class);
        int modifiers = field.getModifiers();
        String fieldName = field.getName();
        return ignore != null && ignore.value() || fieldName.equals("rowID") || fieldName.equals("shadow$_klass_") || fieldName.equals("shadow$_monitor_") || field.isSynthetic() || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers);
    }

    static boolean isWrapper(Class<? extends AbsDbWrapper> clazz) {
        Wrapper w = clazz.getAnnotation(Wrapper.class);
        return w != null;
    }

    static boolean isMany(Field field) {
        Many oneToMany = field.getAnnotation(Many.class);
        return oneToMany != null;
    }

    static boolean isOne(Field field) {
        One oneToOne = field.getAnnotation(One.class);
        return oneToOne != null;
    }

    static boolean isPrimary(Field field) {
        Primary pk = field.getAnnotation(Primary.class);
        return pk != null;
    }

    static boolean isForeign(Field field) {
        Foreign fk = field.getAnnotation(Foreign.class);
        return fk != null;
    }

    static boolean isNoNull(Field field) {
        NoNull nn = field.getAnnotation(NoNull.class);
        return nn != null;
    }

    static boolean isDefault(Field field) {
        Default nn = field.getAnnotation(Default.class);
        return nn != null;
    }

    static boolean isUnique(Field field) {
        Unique nn = field.getAnnotation(Unique.class);
        return nn != null;
    }

    private static Object checkData(String type, String data) {
        if (type.equalsIgnoreCase("java.lang.String")) {
            return data;
        }
        if (type.equalsIgnoreCase("int") || type.equals("java.lang.Integer")) {
            return Integer.parseInt(data);
        }
        if (type.equalsIgnoreCase("double") || type.equals("java.lang.Double")) {
            return Double.parseDouble(data);
        }
        if (type.equalsIgnoreCase("float") || type.equals("java.lang.Float")) {
            return Float.valueOf(Float.parseFloat(data));
        }
        return null;
    }
}

