/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

public class BandwidthLimiter {
    public static int maxBandWith = 2048;
    private static Long KB = 1024L;
    private static Long CHUNK_LENGTH = 1024L;
    private int bytesWillBeSentOrReceive = 0;
    private long lastPieceSentOrReceiveTick = System.nanoTime();
    private int maxRate = 1024;
    private long timeCostPerChunk = 1000000000L * CHUNK_LENGTH / ((long)this.maxRate * KB);

    public BandwidthLimiter(int maxRate, int threadNum) {
        if (threadNum > 1) {
            maxRate /= threadNum;
        }
        this.setMaxRate(maxRate);
    }

    public synchronized void setMaxRate(int maxRate) throws IllegalArgumentException {
        if (maxRate < 0) {
            throw new IllegalArgumentException("maxRate can not less than 0");
        }
        this.maxRate = maxRate;
        this.timeCostPerChunk = maxRate == 0 ? 0L : 1000000000L * CHUNK_LENGTH / ((long)this.maxRate * KB);
    }

    public synchronized void limitNextBytes() {
        this.limitNextBytes(1);
    }

    public synchronized void limitNextBytes(int len) {
        this.bytesWillBeSentOrReceive += len;
        while (!Thread.currentThread().isInterrupted() && (long)this.bytesWillBeSentOrReceive > CHUNK_LENGTH) {
            long nowTick = System.nanoTime();
            long missedTime = this.timeCostPerChunk - (nowTick - this.lastPieceSentOrReceiveTick);
            if (missedTime > 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(missedTime / 1000000L, (int)(missedTime % 1000000L));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.bytesWillBeSentOrReceive = (int)((long)this.bytesWillBeSentOrReceive - CHUNK_LENGTH);
            this.lastPieceSentOrReceiveTick = nowTick + (missedTime > 0L ? missedTime : 0L);
        }
    }
}

