/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.text.TextUtils;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.DeleteDGRecord;
import com.arialyy.aria.util.RecordUtil;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckUtil {
    private static final String TAG = "CheckUtil";

    public static boolean checkIp(String ip) {
        if (TextUtils.isEmpty((CharSequence)ip) || ip.length() < 7 || ip.length() > 15) {
            return false;
        }
        Pattern p = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
        Matcher m = p.matcher(ip);
        return m.find() && m.groupCount() > 0;
    }

    public static boolean httpIsBadRequest(int errorCode) {
        return errorCode == 502 || errorCode == 405 || errorCode == 400;
    }

    public static boolean ftpIsBadRequest(int errorCode) {
        return errorCode >= 400 && errorCode < 600;
    }

    public static boolean checkDPathConflicts(boolean isForceDownload, String filePath, int type) {
        if (DbEntity.checkDataExist(DownloadEntity.class, "downloadPath=?", filePath)) {
            if (!isForceDownload) {
                ALog.e(TAG, String.format("\u4e0b\u8f7d\u5931\u8d25\uff0c\u4fdd\u5b58\u8def\u5f84\u3010%s\u3011\u5df2\u7ecf\u88ab\u5176\u5b83\u4efb\u52a1\u5360\u7528\uff0c\u8bf7\u8bbe\u7f6e\u5176\u5b83\u4fdd\u5b58\u8def\u5f84", filePath));
                return false;
            }
            ALog.w(TAG, String.format("\u4fdd\u5b58\u8def\u5f84\u3010%s\u3011\u5df2\u7ecf\u88ab\u5176\u5b83\u4efb\u52a1\u5360\u7528\uff0c\u5f53\u524d\u4efb\u52a1\u5c06\u8986\u76d6\u8be5\u8def\u5f84\u7684\u6587\u4ef6", filePath));
            RecordUtil.delTaskRecord(filePath, type, false, true);
            return true;
        }
        return true;
    }

    public static boolean checkUPathConflicts(boolean isForceUpload, String filePath, int type) {
        if (DbEntity.checkDataExist(UploadEntity.class, "filePath=?", filePath)) {
            if (!isForceUpload) {
                ALog.e(TAG, String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u3010%s\u3011\u5df2\u7ecf\u88ab\u5176\u5b83\u4efb\u52a1\u5360\u7528\uff0c\u8bf7\u8bbe\u7f6e\u5176\u5b83\u6587\u4ef6\u8def\u5f84", filePath));
                return false;
            }
            ALog.w(TAG, String.format("\u6587\u4ef6\u8def\u5f84\u3010%s\u3011\u5df2\u7ecf\u88ab\u5176\u5b83\u4efb\u52a1\u5360\u7528\uff0c\u5f53\u524d\u4efb\u52a1\u5c06\u8986\u76d6\u8be5\u8def\u5f84\u7684\u6587\u4ef6", filePath));
            RecordUtil.delTaskRecord(filePath, type, false, true);
            return true;
        }
        return true;
    }

    public static boolean checkDGPathConflicts(boolean isForceDownload, String dirPath) {
        if (DbEntity.checkDataExist(DownloadGroupEntity.class, "dirPath=?", dirPath)) {
            if (!isForceDownload) {
                ALog.e(TAG, String.format("\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u5939\u8def\u5f84\u3010%s\u3011\u5df2\u7ecf\u88ab\u5176\u5b83\u4efb\u52a1\u5360\u7528\uff0c\u8bf7\u8bbe\u7f6e\u5176\u5b83\u6587\u4ef6\u8def\u5f84", dirPath));
                return false;
            }
            ALog.w(TAG, String.format("\u6587\u4ef6\u5939\u8def\u5f84\u3010%s\u3011\u5df2\u7ecf\u88ab\u5176\u5b83\u4efb\u52a1\u5360\u7528\uff0c\u5f53\u524d\u4efb\u52a1\u5c06\u8986\u76d6\u8be5\u8def\u5f84", dirPath));
            DeleteDGRecord.getInstance().deleteRecord(dirPath, false, true);
            return true;
        }
        return true;
    }

    public static void checkMemberClass(Class clazz) {
        int modifiers = clazz.getModifiers();
        if (!clazz.isMemberClass() || !Modifier.isStatic(modifiers)) {
            ALog.e(TAG, String.format("\u4e3a\u4e86\u9632\u6b62\u5185\u5b58\u6cc4\u6f0f\uff0c\u8bf7\u4f7f\u7528\u9759\u6001\u7684\u6210\u5458\u7c7b(public static class %s)\u6216\u6587\u4ef6\u7c7b(%s.java)", clazz.getSimpleName(), clazz.getSimpleName()));
        }
    }

    public static void checkPageParams(int page, int num) {
        if (page < 1 || num < 1) {
            throw new NullPointerException("page\u548cnum\u4e0d\u80fd\u5c0f\u4e8e1");
        }
    }

    public static boolean checkUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            ALog.e(TAG, "url\u4e0d\u80fd\u4e3anull");
            return false;
        }
        if (!(url.startsWith("http") || url.startsWith("ftp") || url.startsWith("sftp"))) {
            ALog.e(TAG, "url\u3010" + url + "\u3011\u9519\u8bef");
            return false;
        }
        int index = url.indexOf("://");
        if (index == -1) {
            ALog.e(TAG, "url\u3010" + url + "\u3011\u4e0d\u5408\u6cd5");
        }
        return true;
    }

    public static boolean checkDownloadUrlsIsEmpty(List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            ALog.e(TAG, "\u94fe\u63a5\u7ec4\u4e0d\u80fd\u4e3anull");
            return true;
        }
        return false;
    }

    public static void checkUploadPathIsEmpty(String uploadPath) {
        if (TextUtils.isEmpty((CharSequence)uploadPath)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u5730\u5740\u4e0d\u80fd\u4e3anull");
        }
    }
}

