/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.util.ALog;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtil {
    private static final String TAG = "CommonUtil";
    public static final String SERVER_CHARSET = "ISO-8859-1";
    private static long lastClickTime;
    private static List<String> mFragmentClassName;
    private static List<String> mDialogFragmentClassName;

    public static Activity getFragmentActivity(Object obj) {
        try {
            Method method = obj.getClass().getMethod("getActivity", new Class[0]);
            return (Activity)method.invoke(obj, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isFragment(Class subClazz) {
        Class parentClass = subClazz.getSuperclass();
        if (parentClass == null) {
            return false;
        }
        String parentName = parentClass.getName();
        if (mFragmentClassName.contains(parentName)) {
            return true;
        }
        return CommonUtil.isFragment(parentClass);
    }

    public static boolean isDialogFragment(Class subClazz) {
        Class parentClass = subClazz.getSuperclass();
        if (parentClass == null) {
            return false;
        }
        String parentName = parentClass.getName();
        if (mDialogFragmentClassName.contains(parentName)) {
            return true;
        }
        return CommonUtil.isDialogFragment(parentClass);
    }

    public static boolean isLocalOrAnonymousClass(Class clazz) {
        return clazz.isLocalClass() || clazz.isAnonymousClass();
    }

    public static String getTargetName(Object obj) {
        String targetName;
        if (CommonUtil.isLocalOrAnonymousClass(obj.getClass())) {
            Log.w((String)TAG, (String)String.format("%s \u662f\u533f\u540d\u5185\u90e8\u7c7b\u6216\u5c40\u90e8\u7c7b\uff0c\u5c06\u4f7f\u7528\u5176\u4e3b\u7c7b\u7684\u5bf9\u8c61", obj.getClass().getName()));
            String clsName = obj.getClass().getName();
            int $Index = clsName.lastIndexOf("$");
            targetName = clsName.substring(0, $Index);
        } else {
            targetName = obj.getClass().getName();
        }
        return targetName;
    }

    public static String getThreadName(String url, int threadId) {
        return CommonUtil.getStrMd5(url.concat(String.valueOf(threadId)));
    }

    public static boolean checkSqlExpression(String ... expression) {
        if (expression.length == 0) {
            ALog.e(TAG, "sql\u8bed\u53e5\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3anull");
            return false;
        }
        String where = expression[0];
        Pattern pattern = Pattern.compile("\\?");
        Matcher matcher = pattern.matcher(where);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count < expression.length - 1) {
            ALog.e(TAG, String.format("\u6761\u4ef6\u8bed\u53e5\u7684?\u4e2a\u6570\u4e0d\u80fd\u5c0f\u4e8e\u53c2\u6570\u4e2a\u6570\uff0c\u53c2\u6570\u4fe1\u606f\uff1a%s", Arrays.toString(expression)));
            return false;
        }
        if (count > expression.length - 1) {
            ALog.e(TAG, String.format("\u6761\u4ef6\u8bed\u53e5\u7684?\u4e2a\u6570\u4e0d\u80fd\u5927\u4e8e\u53c2\u6570\u4e2a\u6570\uff0c \u53c2\u6570\u4fe1\u606f\uff1a%s", Arrays.toString(expression)));
            return false;
        }
        return true;
    }

    public static boolean isFastDoubleClick() {
        long time = System.currentTimeMillis();
        long timeD = time - lastClickTime;
        if (0L < timeD && timeD < 500L) {
            ALog.i(TAG, "\u64cd\u4f5c\u592a\u9891\u7e41\u4e86\uff0c\u7f13\u4e00\u4e0b\u5427\uff5e");
            return true;
        }
        lastClickTime = time;
        return false;
    }

    public static String convertFtpChar(String charSet, String str) throws UnsupportedEncodingException {
        return new String(str.getBytes(charSet), SERVER_CHARSET);
    }

    public static String convertSFtpChar(String charSet, String str) throws UnsupportedEncodingException {
        return new String(str.getBytes(), charSet);
    }

    public static List<String> getPkgClassNames(Context context, String className) {
        ArrayList<String> classNameList = new ArrayList<String>();
        String pPath = context.getPackageCodePath();
        File dir = new File(pPath).getParentFile();
        String[] paths = dir.list();
        if (paths == null) {
            classNameList.addAll(CommonUtil.getPkgClassName(pPath, className));
        } else {
            String dPath = dir.getPath();
            for (String path : dir.list()) {
                String fPath = dPath + "/" + path;
                if (!fPath.endsWith(".apk")) continue;
                classNameList.addAll(CommonUtil.getPkgClassName(fPath, className));
            }
        }
        return classNameList;
    }

    public static List<String> getPkgClassName(String path, String filterClass) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            File file = new File(path);
            if (!file.exists()) {
                ALog.w(TAG, String.format("\u8def\u5f84\u3010%s\u3011\u4e0b\u7684Dex\u6587\u4ef6\u4e0d\u5b58\u5728", path));
                return list;
            }
            DexFile df = new DexFile(path);
            Enumeration enumeration = df.entries();
            while (enumeration.hasMoreElements()) {
                String _className = (String)enumeration.nextElement();
                if (!_className.contains(filterClass) || !_className.contains(filterClass)) continue;
                list.add(_className);
            }
            df.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String getWindowReplaceUrl(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            ALog.e(TAG, "\u62e6\u622a\u6570\u636e\u4e3anull");
            return null;
        }
        String reg = "replace\\(\".*\"\\)";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(text);
        if (m.find()) {
            String s = m.group();
            s = s.substring(9, s.length() - 2);
            return s;
        }
        return null;
    }

    public static String getAppPath(Context context) {
        boolean sdExist = "mounted".equals(Environment.getExternalStorageState());
        if (!sdExist) {
            return null;
        }
        File file = context.getExternalFilesDir(null);
        String dir = file != null ? file.getPath() + "/" : Environment.getExternalStorageDirectory().getPath() + "/Android/data/" + context.getPackageName() + "/files/";
        return dir;
    }

    public static Class[] getMapParamType(Field map) {
        Class<Map> type = map.getType();
        if (!type.isAssignableFrom(Map.class)) {
            ALog.d(TAG, "\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662fMap");
            return null;
        }
        Type fc = map.getGenericType();
        if (fc == null) {
            ALog.d(TAG, "\u8be5\u5b57\u6bb5\u6ca1\u6709\u6cdb\u578b\u53c2\u6570");
            return null;
        }
        if (fc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)fc;
            Type[] types = pt.getActualTypeArguments();
            Class[] clazz = new Class[]{(Class)types[0], (Class)types[1]};
            return clazz;
        }
        return null;
    }

    public static Class getListParamType(Field list) {
        Class<List> type = list.getType();
        if (!type.isAssignableFrom(List.class)) {
            ALog.d(TAG, "\u5b57\u6bb5\u7c7b\u578b\u4e0d\u662fList");
            return null;
        }
        Type fc = list.getGenericType();
        if (fc == null) {
            ALog.d(TAG, "\u8be5\u5b57\u6bb5\u6ca1\u6709\u6cdb\u578b\u53c2\u6570");
            return null;
        }
        if (fc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)fc;
            return (Class)pt.getActualTypeArguments()[0];
        }
        return null;
    }

    public static FtpUrlEntity getFtpUrlInfo(String url) {
        Uri uri = Uri.parse((String)url);
        String userInfo = uri.getUserInfo();
        String remotePath = uri.getPath();
        ALog.d(TAG, String.format("scheme = %s, user = %s, host = %s, port = %s, path = %s", uri.getScheme(), userInfo, uri.getHost(), uri.getPort(), remotePath));
        FtpUrlEntity entity = new FtpUrlEntity();
        entity.url = url;
        entity.hostName = uri.getHost();
        String string = entity.port = uri.getPort() == -1 ? "21" : String.valueOf(uri.getPort());
        if (!TextUtils.isEmpty((CharSequence)userInfo)) {
            String[] temp = userInfo.split(":");
            if (temp.length == 2) {
                entity.user = temp[0];
                entity.password = temp[1];
            } else {
                entity.user = userInfo;
            }
        }
        entity.scheme = uri.getScheme();
        entity.remotePath = TextUtils.isEmpty((CharSequence)remotePath) ? "/" : remotePath;
        return entity;
    }

    public static String convertUrl(String url) {
        Uri uri = Uri.parse((String)url);
        if (CommonUtil.hasDoubleCharacter(url = uri.toString())) {
            url = url.replaceAll(" ", "%20");
            String regex = "[^\\x00-\\xff]|[\\s\\p{Zs}]";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(url);
            HashSet<String> strs = new HashSet<String>();
            while (m.find()) {
                strs.add(m.group());
            }
            try {
                for (String str : strs) {
                    url = url.replaceAll(str, URLEncoder.encode(str, "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public static boolean hasDoubleCharacter(String chineseStr) {
        char[] charArray;
        for (char aCharArray : charArray = chineseStr.toCharArray()) {
            if ((aCharArray < '\u0391' || aCharArray > '\uffe5') && aCharArray != '\r' && aCharArray != '\n' && aCharArray != ' ') continue;
            return true;
        }
        return false;
    }

    public static String decryptBASE64(String str) {
        return new String(Base64.decode((byte[])str.getBytes(), (int)0));
    }

    public static String encryptBASE64(String str) {
        return Base64.encodeToString((byte[])str.getBytes(), (int)0);
    }

    public static String strCharSetConvert(String oldStr, String charSet) {
        try {
            return new String(oldStr.getBytes(), charSet);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMd5Code(List<String> urls) {
        if (urls == null || urls.size() < 1) {
            return "";
        }
        String md5 = "";
        StringBuilder sb = new StringBuilder();
        for (String url : urls) {
            sb.append(url);
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sb.toString().getBytes());
            md5 = new BigInteger(1, md.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            ALog.e(TAG, e.getMessage());
        }
        return md5;
    }

    public static String getStrMd5(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getCoresNum() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]", pathname.getName());
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            ALog.d(TAG, "CPU Count: " + files.length);
            return files.length;
        }
        catch (Exception e) {
            ALog.d(TAG, "CPU Count: Failed.");
            e.printStackTrace();
            return 1;
        }
    }

    public static boolean checkMD5(String md5, File updateFile) {
        if (TextUtils.isEmpty((CharSequence)md5) || updateFile == null) {
            ALog.e(TAG, "MD5 string empty or updateFile null");
            return false;
        }
        String calculatedDigest = CommonUtil.getFileMD5(updateFile);
        if (calculatedDigest == null) {
            ALog.e(TAG, "calculatedDigest null");
            return false;
        }
        return calculatedDigest.equalsIgnoreCase(md5);
    }

    public static boolean checkMD5(String md5, InputStream is) {
        if (TextUtils.isEmpty((CharSequence)md5) || is == null) {
            ALog.e(TAG, "MD5 string empty or updateFile null");
            return false;
        }
        String calculatedDigest = CommonUtil.getFileMD5(is);
        if (calculatedDigest == null) {
            ALog.e(TAG, "calculatedDigest null");
            return false;
        }
        return calculatedDigest.equalsIgnoreCase(md5);
    }

    public static String getFileMD5(File updateFile) {
        FileInputStream is;
        try {
            is = new FileInputStream(updateFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return CommonUtil.getFileMD5(is);
    }

    public static String getFileMD5(InputStream is) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        byte[] buffer = new byte[8192];
        try {
            int read;
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String output = bigInt.toString(16);
            String string = output = String.format("%32s", output).replace(' ', '0');
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to process file for MD5", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Intent createIntent(String packageName, String action) {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(packageName);
        Uri uri = builder.build();
        Intent intent = new Intent(action);
        intent.setData(uri);
        return intent;
    }

    public static Boolean putString(String preName, Context context, String key, String value) {
        SharedPreferences pre = context.getSharedPreferences(preName, 0);
        SharedPreferences.Editor editor = pre.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    public static String getString(String preName, Context context, String key) {
        SharedPreferences pre = context.getSharedPreferences(preName, 0);
        return pre.getString(key, "");
    }

    public static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class personClazz = clazz.getSuperclass();
        if (personClazz != null) {
            Class rootClazz = personClazz.getSuperclass();
            if (rootClazz != null) {
                Collections.addAll(fields, rootClazz.getDeclaredFields());
            }
            Collections.addAll(fields, personClazz.getDeclaredFields());
        }
        Collections.addAll(fields, clazz.getDeclaredFields());
        ArrayList<Field> ignore = new ArrayList<Field>();
        for (Field field : fields) {
            if (!field.getName().equals("shadow$_klass_") && !field.getName().equals("shadow$_monitor_")) continue;
            ignore.add(field);
        }
        if (!ignore.isEmpty()) {
            fields.removeAll(ignore);
        }
        return fields;
    }

    public static Field[] getFields(Class clazz) {
        Class superClazz;
        Field[] fields = clazz.getDeclaredFields();
        if (fields.length == 0 && (superClazz = clazz.getSuperclass()) != null) {
            fields = CommonUtil.getFields(superClazz);
        }
        return fields;
    }

    public static Field getField(Class clazz, String name) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            try {
                field = clazz.getField(name);
            }
            catch (NoSuchFieldException e1) {
                if (clazz.getSuperclass() == null) {
                    return null;
                }
                field = CommonUtil.getField(clazz.getSuperclass(), name);
            }
        }
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Method getMethod(Class clazz, String methodName, Class<?> ... params) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, params);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getMethod(methodName, params);
            }
            catch (NoSuchMethodException ex) {
                if (clazz.getSuperclass() == null) {
                    return null;
                }
                method = CommonUtil.getMethod(clazz.getSuperclass(), methodName, params);
            }
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static int keyToHashCode(String str) {
        int total = 0;
        for (int i = 0; i < str.length(); ++i) {
            int ch = str.charAt(i);
            if (ch == 45) {
                ch = 28;
            }
            if (ch == 39) {
                ch = 29;
            }
            total = total * 33 + (ch & 0x1F);
        }
        return total;
    }

    public static String keyToHashKey(String key) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = CommonUtil.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("0x");
        if (src == null || src.length <= 0) {
            return null;
        }
        char[] buffer = new char[2];
        for (byte aSrc : src) {
            buffer[0] = Character.forDigit(aSrc >>> 4 & 0xF, 16);
            buffer[1] = Character.forDigit(aSrc & 0xF, 16);
            stringBuilder.append(buffer);
        }
        return stringBuilder.toString();
    }

    public static String getClassName(Object obj) {
        String[] arrays = obj.getClass().getName().split("\\.");
        return arrays[arrays.length - 1];
    }

    public static String getClassName(Class clazz) {
        String[] arrays = clazz.getName().split("\\.");
        return arrays[arrays.length - 1];
    }

    public static String formatFileSize(double size) {
        if (size < 0.0) {
            return "0kb";
        }
        double kiloByte = size / 1024.0;
        if (kiloByte < 1.0) {
            return size + "b";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "kb";
        }
        double gigaByte = megaByte / 1024.0;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
            return result2.setScale(2, 4).toPlainString() + "mb";
        }
        double teraBytes = gigaByte / 1024.0;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "gb";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "tb";
    }

    public static String formatTime(int seconds) {
        String standardTime = seconds <= 0 ? "00:00" : (seconds < 60 ? String.format(Locale.getDefault(), "00:%02d", seconds % 60) : (seconds < 3600 ? String.format(Locale.getDefault(), "%02d:%02d", seconds / 60, seconds % 60) : (seconds < 86400 ? String.format(Locale.getDefault(), "%02d:%02d:%02d", seconds / 3600, seconds % 3600 / 60, seconds % 60) : (seconds < 604800 ? String.format(Locale.getDefault(), "%dd %02d:%02d", seconds / 86400, seconds % 86400 / 3600, seconds % 3600) : "\u221e"))));
        return standardTime;
    }

    public static String getFileConfigPath(boolean isDownload, String fileName) {
        return AriaConfig.getInstance().getAPP().getFilesDir().getPath() + (isDownload ? "/Aria/temp/download/" : "/Aria/temp/upload/") + fileName + ".properties";
    }

    static {
        mFragmentClassName = new ArrayList<String>();
        mDialogFragmentClassName = new ArrayList<String>();
        mFragmentClassName.add("androidx.fragment.app.Fragment");
        mFragmentClassName.add("androidx.fragment.app.DialogFragment");
        mFragmentClassName.add("android.app.Fragment");
        mFragmentClassName.add("android.app.DialogFragment");
        mFragmentClassName.add("android.support.v4.app.Fragment");
        mFragmentClassName.add("android.support.v4.app.DialogFragment");
        mDialogFragmentClassName.add("androidx.fragment.app.DialogFragment");
        mDialogFragmentClassName.add("android.app.DialogFragment");
        mDialogFragmentClassName.add("android.support.v4.app.DialogFragment");
    }
}

