/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.download.DGEntityWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.orm.DbEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DbDataHelper {
    public static TaskRecord getTaskRecord(String filePath, int taskType) {
        TaskRecord taskRecord = DbEntity.findFirst(TaskRecord.class, "filePath=? AND taskType=?", filePath, String.valueOf(taskType));
        if (taskRecord != null) {
            taskRecord.threadRecords = DbEntity.findDatas(ThreadRecord.class, "taskKey=? AND threadType=?", filePath, String.valueOf(taskType));
        }
        return taskRecord;
    }

    public static DownloadGroupEntity getDGEntityByHash(String groupHash) {
        List<DGEntityWrapper> wrapper = DbEntity.findRelationData(DGEntityWrapper.class, "DownloadGroupEntity.groupHash=?", groupHash);
        return wrapper == null || wrapper.size() == 0 ? null : wrapper.get((int)0).groupEntity;
    }

    public static DownloadGroupEntity getDGEntityByPath(String dirPath) {
        List<DGEntityWrapper> wrapper = DbEntity.findRelationData(DGEntityWrapper.class, "DownloadGroupEntity.dirPath=?", dirPath);
        return wrapper == null || wrapper.size() == 0 ? null : wrapper.get((int)0).groupEntity;
    }

    public static DownloadGroupEntity getDGEntity(long taskId) {
        List<DGEntityWrapper> wrapper = DbEntity.findRelationData(DGEntityWrapper.class, "DownloadGroupEntity.rowid=?", String.valueOf(taskId));
        return wrapper == null || wrapper.size() == 0 ? null : wrapper.get((int)0).groupEntity;
    }

    public static List<DownloadEntity> createHttpSubTask(String groupHash, List<String> urls) {
        ArrayList<DownloadEntity> list = new ArrayList<DownloadEntity>();
        int len = urls.size();
        for (int i = 0; i < len; ++i) {
            String url = urls.get(i);
            DownloadEntity entity = new DownloadEntity();
            entity.setUrl(url);
            entity.setFilePath(groupHash + "_" + i);
            int lastIndex = url.lastIndexOf(File.separator);
            int endIndex = url.lastIndexOf("?");
            if (endIndex < 0 || endIndex < lastIndex) {
                endIndex = url.length();
            }
            entity.setFileName(url.substring(lastIndex + 1, endIndex));
            entity.setGroupHash(groupHash);
            entity.setGroupChild(true);
            list.add(entity);
        }
        return list;
    }

    public static DownloadGroupEntity getOrCreateFtpDGEntity(String ftpUrl) {
        DownloadGroupEntity groupEntity;
        List<DGEntityWrapper> wrapper = DbEntity.findRelationData(DGEntityWrapper.class, "DownloadGroupEntity.groupHash=?", ftpUrl);
        if (wrapper != null && !wrapper.isEmpty()) {
            groupEntity = wrapper.get((int)0).groupEntity;
            if (groupEntity == null) {
                groupEntity = new DownloadGroupEntity();
            }
        } else {
            groupEntity = new DownloadGroupEntity();
        }
        groupEntity.setGroupHash(ftpUrl);
        return groupEntity;
    }

    public static List<DTaskWrapper> createDGSubTaskWrapper(DownloadGroupEntity dge) {
        ArrayList<DTaskWrapper> list = new ArrayList<DTaskWrapper>();
        for (DownloadEntity entity : dge.getSubEntities()) {
            DTaskWrapper taskEntity = new DTaskWrapper(entity);
            taskEntity.setGroupHash(dge.getKey());
            taskEntity.setGroupTask(true);
            list.add(taskEntity);
        }
        return list;
    }
}

