/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.text.TextUtils;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.M3U8Entity;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DbDataHelper;
import com.arialyy.aria.util.FileUtil;
import com.arialyy.aria.util.IDeleteRecord;
import java.io.File;

public class DeleteM3u8Record
implements IDeleteRecord {
    private String TAG = CommonUtil.getClassName(this);
    private static volatile DeleteM3u8Record INSTANCE = null;

    private DeleteM3u8Record() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeleteM3u8Record getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DeleteM3u8Record> clazz = DeleteM3u8Record.class;
        synchronized (DeleteM3u8Record.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DeleteM3u8Record();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void deleteRecord(String filePath, boolean removeTarget, boolean needRemoveEntity) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new NullPointerException("\u5220\u9664\u8bb0\u5f55\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        }
        if (!filePath.startsWith("/")) {
            throw new IllegalArgumentException(String.format("\u6587\u4ef6\u8def\u5f84\u9519\u8bef\uff0cfilePath\uff1a%s", filePath));
        }
        DownloadEntity entity = DbEntity.findFirst(DownloadEntity.class, "downloadPath=?", filePath);
        if (entity == null) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\u5931\u8d25\uff0c\u6ca1\u6709\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u4f53\u6587\u4ef6\uff0cfilePath\uff1a" + filePath);
            return;
        }
        this.deleteRecord(entity, removeTarget, needRemoveEntity);
    }

    @Override
    public void deleteRecord(AbsEntity absEntity, boolean needRemoveFile, boolean needRemoveEntity) {
        if (absEntity == null) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\u5931\u8d25\uff0c\u5b9e\u4f53\u4e3a\u7a7a");
            return;
        }
        DownloadEntity entity = (DownloadEntity)absEntity;
        String filePath = entity.getFilePath();
        TaskRecord record = DbDataHelper.getTaskRecord(filePath, entity.getTaskType());
        if (record == null) {
            ALog.e(this.TAG, "\u5220\u9664\u4e0b\u8f7d\u8bb0\u5f55\u5931\u8d25\uff0c\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u5c06\u5220\u9664\u5b9e\u4f53\u8bb0\u5f55\uff0cfilePath\uff1a" + entity.getFilePath());
            this.deleteEntity(entity.getTaskType(), needRemoveEntity, filePath);
            return;
        }
        if (needRemoveFile || !entity.isComplete()) {
            DeleteM3u8Record.removeTsCache(new File(filePath), record.bandWidth);
            FileUtil.deleteFile(filePath);
        }
        this.deleteEntity(entity.getTaskType(), needRemoveEntity, filePath);
    }

    private void deleteEntity(int taskType, boolean needRemoveEntity, String filePath) {
        DbEntity.deleteData(ThreadRecord.class, "taskKey=? AND threadType=?", filePath, String.valueOf(taskType));
        DbEntity.deleteData(TaskRecord.class, "filePath=? AND taskType=?", filePath, String.valueOf(taskType));
        DbEntity.deleteData(M3U8Entity.class, "filePath=?", filePath);
        if (needRemoveEntity) {
            DbEntity.deleteData(DownloadEntity.class, "downloadPath=?", filePath);
        }
    }

    private static void removeTsCache(File targetFile, long bandWidth) {
        File indexFile;
        M3U8Entity entity = DbEntity.findFirst(M3U8Entity.class, "filePath=?", targetFile.getPath());
        if (entity != null && !TextUtils.isEmpty((CharSequence)entity.keyPath)) {
            File keyFile = new File(entity.keyPath);
            FileUtil.deleteFile(keyFile);
        }
        String cacheDir = null;
        if (!targetFile.isDirectory()) {
            cacheDir = String.format("%s/.%s_%s", targetFile.getParent(), targetFile.getName(), bandWidth);
        }
        if (!TextUtils.isEmpty(cacheDir)) {
            File[] files;
            File cacheDirF = new File(cacheDir);
            if (!cacheDirF.exists()) {
                return;
            }
            for (File f : files = cacheDirF.listFiles()) {
                if (!f.exists()) continue;
                f.delete();
            }
            File cDir = new File(cacheDir);
            if (cDir.exists()) {
                cDir.delete();
            }
        }
        if ((indexFile = new File(String.format("%s.index", targetFile.getPath()))).exists()) {
            indexFile.delete();
        }
    }
}

