/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.appiconloader.iconloaderlib;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import me.zhanghai.android.appiconloader.iconloaderlib.BaseIconFactory;

public class BitmapInfo {
    public static final Bitmap LOW_RES_ICON = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ALPHA_8);
    public static final BitmapInfo LOW_RES_INFO = BitmapInfo.fromBitmap(LOW_RES_ICON);
    public final Bitmap icon;
    public final int color;

    public BitmapInfo(Bitmap icon, int color) {
        this.icon = icon;
        this.color = color;
    }

    public final boolean isNullOrLowRes() {
        return this.icon == null || this.icon == LOW_RES_ICON;
    }

    public final boolean isLowRes() {
        return LOW_RES_ICON == this.icon;
    }

    public static BitmapInfo fromBitmap(@NonNull Bitmap bitmap) {
        return BitmapInfo.of(bitmap, 0);
    }

    public static BitmapInfo of(@NonNull Bitmap bitmap, int color) {
        return new BitmapInfo(bitmap, color);
    }

    public static interface Extender {
        default public BitmapInfo getExtendedInfo(Bitmap bitmap, int color, BaseIconFactory iconFactory) {
            return BitmapInfo.of(bitmap, color);
        }

        default public void prepareToDrawOnUi() {
        }
    }
}

