/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.appiconloader.iconloaderlib;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Rect;
import android.util.Log;
import android.view.ViewDebug;
import me.zhanghai.android.appiconloader.iconloaderlib.ShadowGenerator;

public class DotRenderer {
    private static final String TAG = "DotRenderer";
    private static final float SIZE_PERCENTAGE = 0.228f;
    private final float mCircleRadius;
    private final Paint mCirclePaint = new Paint(3);
    private final Bitmap mBackgroundWithShadow;
    private final float mBitmapOffset;
    private final float[] mRightDotPosition;
    private final float[] mLeftDotPosition;

    public DotRenderer(int iconSizePx, Path iconShapePath, int pathSize) {
        int size = Math.round(0.228f * (float)iconSizePx);
        ShadowGenerator.Builder builder = new ShadowGenerator.Builder(0);
        builder.ambientShadowAlpha = 88;
        this.mBackgroundWithShadow = builder.setupBlurForSize(size).createPill(size, size);
        this.mCircleRadius = builder.radius;
        this.mBitmapOffset = (float)(-this.mBackgroundWithShadow.getHeight()) * 0.5f;
        this.mLeftDotPosition = DotRenderer.getPathPoint(iconShapePath, pathSize, -1.0f);
        this.mRightDotPosition = DotRenderer.getPathPoint(iconShapePath, pathSize, 1.0f);
    }

    private static float[] getPathPoint(Path path, float size, float direction) {
        float halfSize = size / 2.0f;
        float delta = 1.0f;
        float x = halfSize + direction * halfSize;
        Path trianglePath = new Path();
        trianglePath.moveTo(halfSize, halfSize);
        trianglePath.lineTo(x + delta * direction, 0.0f);
        trianglePath.lineTo(x, -delta);
        trianglePath.close();
        trianglePath.op(path, Path.Op.INTERSECT);
        float[] pos = new float[2];
        new PathMeasure(trianglePath, false).getPosTan(0.0f, pos, null);
        pos[0] = pos[0] / size;
        pos[1] = pos[1] / size;
        return pos;
    }

    public float[] getLeftDotPosition() {
        return this.mLeftDotPosition;
    }

    public float[] getRightDotPosition() {
        return this.mRightDotPosition;
    }

    public void draw(Canvas canvas, DrawParams params) {
        if (params == null) {
            Log.e((String)TAG, (String)"Invalid null argument(s) passed in call to draw.");
            return;
        }
        canvas.save();
        Rect iconBounds = params.iconBounds;
        float[] dotPosition = params.leftAlign ? this.mLeftDotPosition : this.mRightDotPosition;
        float dotCenterX = (float)iconBounds.left + (float)iconBounds.width() * dotPosition[0];
        float dotCenterY = (float)iconBounds.top + (float)iconBounds.height() * dotPosition[1];
        Rect canvasBounds = canvas.getClipBounds();
        float offsetX = params.leftAlign ? Math.max(0.0f, (float)canvasBounds.left - (dotCenterX + this.mBitmapOffset)) : Math.min(0.0f, (float)canvasBounds.right - (dotCenterX - this.mBitmapOffset));
        float offsetY = Math.max(0.0f, (float)canvasBounds.top - (dotCenterY + this.mBitmapOffset));
        canvas.translate(dotCenterX + offsetX, dotCenterY + offsetY);
        canvas.scale(params.scale, params.scale);
        this.mCirclePaint.setColor(-16777216);
        canvas.drawBitmap(this.mBackgroundWithShadow, this.mBitmapOffset, this.mBitmapOffset, this.mCirclePaint);
        this.mCirclePaint.setColor(params.color);
        canvas.drawCircle(0.0f, 0.0f, this.mCircleRadius, this.mCirclePaint);
        canvas.restore();
    }

    public static class DrawParams {
        @ViewDebug.ExportedProperty(category="notification dot", formatToHexString=true)
        public int color;
        @ViewDebug.ExportedProperty(category="notification dot")
        public Rect iconBounds = new Rect();
        @ViewDebug.ExportedProperty(category="notification dot")
        public float scale;
        @ViewDebug.ExportedProperty(category="notification dot")
        public boolean leftAlign;
    }
}

