/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.effortlesspermissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import me.zhanghai.android.effortlesspermissions.AfterPermissionDenied;
import pub.devrel.easypermissions.EasyPermissions;
import pub.devrel.easypermissions.PermissionRequest;

public class EffortlessPermissions {
    private static final String TAG = EffortlessPermissions.class.getSimpleName();

    private EffortlessPermissions() {
    }

    public static boolean hasPermissions(Context context, String ... permissions) {
        return EasyPermissions.hasPermissions((Context)context, (String[])permissions);
    }

    public static boolean hasPermissions(Fragment fragment, String ... permissions) {
        return EasyPermissions.hasPermissions((Context)fragment.getContext(), (String[])permissions);
    }

    public static void requestPermissions(@NonNull Activity host, @NonNull String rationale, int requestCode, String ... permissions) {
        EasyPermissions.requestPermissions((Activity)host, (String)rationale, (int)requestCode, (String[])permissions);
    }

    public static void requestPermissions(@NonNull Fragment host, @NonNull String rationale, int requestCode, String ... permissions) {
        EasyPermissions.requestPermissions((Fragment)host, (String)rationale, (int)requestCode, (String[])permissions);
    }

    public static void requestPermissions(PermissionRequest permissionRequest) {
        EasyPermissions.requestPermissions((PermissionRequest)permissionRequest);
    }

    public static void requestPermissions(@NonNull Activity host, @StringRes int rationale, int requestCode, String ... permissions) {
        EffortlessPermissions.requestPermissions(host, host.getString(rationale), requestCode, permissions);
    }

    public static void requestPermissions(@NonNull Fragment host, @StringRes int rationale, int requestCode, String ... permissions) {
        EffortlessPermissions.requestPermissions(host, host.getString(rationale), requestCode, permissions);
    }

    public static void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults, final Object ... receivers) {
        Object[] allReceivers = new Object[receivers.length + 1];
        System.arraycopy(receivers, 0, allReceivers, 0, receivers.length);
        allReceivers[allReceivers.length - 1] = new EasyPermissions.PermissionCallbacks(){

            public void onPermissionsGranted(int requestCode, List<String> grantedPermissions) {
            }

            public void onPermissionsDenied(int requestCode, List<String> deniedPermissions) {
                for (Object object : receivers) {
                    EffortlessPermissions.runAfterPermissionDenied(object, requestCode, deniedPermissions);
                }
            }

            public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
            }
        };
        EasyPermissions.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults, (Object[])allReceivers);
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Activity host, @NonNull List<String> permissions) {
        return EasyPermissions.somePermissionPermanentlyDenied((Activity)host, permissions);
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Fragment host, @NonNull List<String> permissions) {
        return EasyPermissions.somePermissionPermanentlyDenied((Fragment)host, permissions);
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Activity host, String ... permissions) {
        return EffortlessPermissions.somePermissionPermanentlyDenied(host, Arrays.asList(permissions));
    }

    public static boolean somePermissionPermanentlyDenied(@NonNull Fragment host, String ... permissions) {
        return EasyPermissions.somePermissionPermanentlyDenied((Fragment)host, Arrays.asList(permissions));
    }

    public static boolean permissionPermanentlyDenied(@NonNull Activity host, @NonNull String deniedPermission) {
        return EasyPermissions.permissionPermanentlyDenied((Activity)host, (String)deniedPermission);
    }

    public static boolean permissionPermanentlyDenied(@NonNull Fragment host, @NonNull String deniedPermission) {
        return EasyPermissions.permissionPermanentlyDenied((Fragment)host, (String)deniedPermission);
    }

    public static boolean somePermissionDenied(@NonNull Activity host, String ... permissions) {
        return EasyPermissions.somePermissionDenied((Activity)host, (String[])permissions);
    }

    public static boolean somePermissionDenied(@NonNull Fragment host, String ... permissions) {
        return EasyPermissions.somePermissionDenied((Fragment)host, (String[])permissions);
    }

    private static void runAfterPermissionDenied(@NonNull Object object, int requestCode, List<String> deniedPermissions) {
        Class<?> clazz = object.getClass();
        if (EffortlessPermissions.isUsingAndroidAnnotations(object)) {
            clazz = clazz.getSuperclass();
        }
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                AfterPermissionDenied annotation;
                if (!method.isAnnotationPresent(AfterPermissionDenied.class) || (annotation = method.getAnnotation(AfterPermissionDenied.class)).value() != requestCode) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (!(parameterTypes.length == 0 || parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(List.class))) {
                    throw new RuntimeException("Cannot execute method " + method.getName() + " because its parameter list is not empty or containing only a List<String>.");
                }
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    if (parameterTypes.length == 0) {
                        method.invoke(object, new Object[0]);
                        continue;
                    }
                    method.invoke(object, deniedPermissions);
                }
                catch (IllegalAccessException e) {
                    Log.e((String)TAG, (String)"Running AfterPermissionDenied failed", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)TAG, (String)"Running AfterPermissionDenied failed", (Throwable)e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static boolean isUsingAndroidAnnotations(@NonNull Object object) {
        if (!object.getClass().getSimpleName().endsWith("_")) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("org.androidannotations.api.view.HasViews");
            return clazz.isInstance(object);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

