/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.effortlesspermissions;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.AppCompatDialogFragment;

public class OpenAppDetailsDialogFragment
extends AppCompatDialogFragment {
    private static final String KEY_PREFIX = OpenAppDetailsDialogFragment.class.getName() + '.';
    private static final String EXTRA_REQUEST_CODE = KEY_PREFIX + "REQUEST_CODE";
    private static final String EXTRA_PACKAGE_NAME = KEY_PREFIX + "PACKAGE_NAME";
    private static final String EXTRA_TITLE = KEY_PREFIX + "TITLE";
    private static final String EXTRA_MESSAGE = KEY_PREFIX + "MESSAGE";
    private static final String EXTRA_POSITIVE_BUTTON_TEXT = KEY_PREFIX + "POSITIVE_BUTTON_TEXT";
    private static final String EXTRA_NEGATIVE_BUTTON_TEXT = KEY_PREFIX + "NEGATIVE_BUTTON_TEXT";
    private static final String EXTRA_CANCELABLE = KEY_PREFIX + "CANCELABLE";
    private static final int REQUEST_CODE_INVALID = -1;
    private int mRequestCode;
    private String mPackageName;
    private CharSequence mTitle;
    private CharSequence mMessage;
    private CharSequence mPositiveButtonText;
    private CharSequence mNegativeButtonText;
    private boolean mCancelable;

    public static OpenAppDetailsDialogFragment newInstance(int requestCode, String packageName, CharSequence title, CharSequence message, CharSequence positiveButtonText, CharSequence negativeButtonText, boolean cancelable) {
        OpenAppDetailsDialogFragment fragment = new OpenAppDetailsDialogFragment();
        Bundle arguments = new Bundle();
        arguments.putInt(EXTRA_REQUEST_CODE, requestCode);
        arguments.putString(EXTRA_PACKAGE_NAME, packageName);
        arguments.putCharSequence(EXTRA_TITLE, title);
        arguments.putCharSequence(EXTRA_MESSAGE, message);
        arguments.putCharSequence(EXTRA_POSITIVE_BUTTON_TEXT, positiveButtonText);
        arguments.putCharSequence(EXTRA_NEGATIVE_BUTTON_TEXT, negativeButtonText);
        arguments.putBoolean(EXTRA_CANCELABLE, cancelable);
        fragment.setArguments(arguments);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        this.mRequestCode = arguments.getInt(EXTRA_REQUEST_CODE);
        this.mPackageName = arguments.getString(EXTRA_PACKAGE_NAME);
        this.mTitle = arguments.getCharSequence(EXTRA_TITLE);
        this.mMessage = arguments.getCharSequence(EXTRA_MESSAGE);
        this.mPositiveButtonText = arguments.getCharSequence(EXTRA_POSITIVE_BUTTON_TEXT);
        this.mNegativeButtonText = arguments.getCharSequence(EXTRA_NEGATIVE_BUTTON_TEXT);
        this.mCancelable = arguments.getBoolean(EXTRA_CANCELABLE);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        CharSequence positiveButtonText;
        FragmentActivity activity = this.getActivity();
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity, this.getTheme());
        if (this.mTitle != null) {
            builder.setTitle(this.mTitle);
        }
        if (this.mMessage != null) {
            builder.setMessage(this.mMessage);
        }
        if ((positiveButtonText = this.mPositiveButtonText) == null) {
            positiveButtonText = activity.getText(17039370);
        }
        builder.setPositiveButton(positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                OpenAppDetailsDialogFragment.this.openAppDetails();
            }
        });
        if (this.mNegativeButtonText != null) {
            builder.setNegativeButton(this.mNegativeButtonText, null);
        }
        builder.setCancelable(this.mCancelable);
        return builder.create();
    }

    public void setTargetFragment(Fragment fragment, int requestCode) {
        super.setTargetFragment(fragment, requestCode);
        this.mRequestCode = requestCode;
        this.getArguments().putInt(EXTRA_REQUEST_CODE, requestCode);
    }

    private void openAppDetails() {
        FragmentActivity activity = this.getActivity();
        String packageName = this.mPackageName != null ? this.mPackageName : activity.getPackageName();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts((String)"package", (String)packageName, null));
        Fragment targetFragment = this.getTargetFragment();
        if (targetFragment != null) {
            if (this.mRequestCode != -1) {
                targetFragment.startActivityForResult(intent, this.mRequestCode);
            } else {
                targetFragment.startActivity(intent);
            }
            return;
        }
        Fragment parentFragment = this.getParentFragment();
        if (parentFragment != null) {
            if (this.mRequestCode != -1) {
                parentFragment.startActivityForResult(intent, this.mRequestCode);
            } else {
                parentFragment.startActivity(intent);
            }
            return;
        }
        if (this.mRequestCode != -1) {
            activity.startActivityForResult(intent, this.mRequestCode);
        } else {
            activity.startActivity(intent);
        }
    }

    public static void show(CharSequence title, CharSequence message, CharSequence positiveButtonText, CharSequence negativeButtonText, Fragment fragment) {
        OpenAppDetailsDialogFragment.newInstance(-1, null, title, message, positiveButtonText, negativeButtonText, false).show(fragment.getChildFragmentManager(), null);
    }

    public static void show(@StringRes int titleRes, @StringRes int messageRes, @StringRes int positiveButtonTextRes, @StringRes int negativeButtonTextRes, Fragment fragment) {
        OpenAppDetailsDialogFragment.show(fragment.getText(titleRes), fragment.getText(messageRes), fragment.getText(positiveButtonTextRes), fragment.getText(negativeButtonTextRes), fragment);
    }

    public static void show(@StringRes int messageRes, @StringRes int positiveButtonTextRes, Fragment fragment) {
        OpenAppDetailsDialogFragment.show(null, fragment.getText(messageRes), fragment.getText(positiveButtonTextRes), fragment.getText(0x1040000), fragment);
    }

    public static void show(CharSequence title, CharSequence message, CharSequence positiveButtonText, CharSequence negativeButtonText, AppCompatActivity activity) {
        OpenAppDetailsDialogFragment.newInstance(-1, null, title, message, positiveButtonText, negativeButtonText, false).show(activity.getSupportFragmentManager(), null);
    }

    public static void show(@StringRes int titleRes, @StringRes int messageRes, @StringRes int positiveButtonTextRes, @StringRes int negativeButtonTextRes, AppCompatActivity activity) {
        OpenAppDetailsDialogFragment.show(activity.getText(titleRes), activity.getText(messageRes), activity.getText(positiveButtonTextRes), activity.getText(negativeButtonTextRes), activity);
    }

    public static void show(@StringRes int messageRes, @StringRes int positiveButtonTextRes, AppCompatActivity activity) {
        OpenAppDetailsDialogFragment.show(null, activity.getText(messageRes), activity.getText(positiveButtonTextRes), activity.getText(0x1040000), activity);
    }
}

