/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialedittext;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import me.zhanghai.android.materialedittext.TintableDrawable;

abstract class BaseDrawable
extends Drawable
implements TintableDrawable {
    protected int mAlpha = 255;
    protected ColorFilter mColorFilter;
    protected ColorStateList mTintList;
    protected PorterDuff.Mode mTintMode = PorterDuff.Mode.SRC_IN;
    protected PorterDuffColorFilter mTintFilter;
    private DummyConstantState mConstantState = new DummyConstantState();

    BaseDrawable() {
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(int alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mColorFilter = colorFilter;
        this.invalidateSelf();
    }

    @Override
    public void setTint(@ColorInt int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    @Override
    public void setTintList(@Nullable ColorStateList tint) {
        this.mTintList = tint;
        if (this.updateTintFilter()) {
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintMode(@NonNull PorterDuff.Mode tintMode) {
        this.mTintMode = tintMode;
        if (this.updateTintFilter()) {
            this.invalidateSelf();
        }
    }

    public boolean isStateful() {
        return this.mTintList != null && this.mTintList.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        return this.updateTintFilter();
    }

    private boolean updateTintFilter() {
        if (this.mTintList == null || this.mTintMode == null) {
            boolean hadTintFilter = this.mTintFilter != null;
            this.mTintFilter = null;
            return hadTintFilter;
        }
        int tintColor = this.mTintList.getColorForState(this.getState(), 0);
        this.mTintFilter = new PorterDuffColorFilter(tintColor, this.mTintMode);
        return true;
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (bounds.width() == 0 || bounds.height() == 0) {
            return;
        }
        int saveCount = canvas.save();
        canvas.translate((float)bounds.left, (float)bounds.top);
        this.onDraw(canvas, bounds.width(), bounds.height());
        canvas.restoreToCount(saveCount);
    }

    protected ColorFilter getColorFilterForDrawing() {
        return this.mColorFilter != null ? this.mColorFilter : this.mTintFilter;
    }

    protected abstract void onDraw(Canvas var1, int var2, int var3);

    public Drawable.ConstantState getConstantState() {
        return this.mConstantState;
    }

    private class DummyConstantState
    extends Drawable.ConstantState {
        private DummyConstantState() {
        }

        public int getChangingConfigurations() {
            return 0;
        }

        @NonNull
        public Drawable newDrawable() {
            return BaseDrawable.this;
        }
    }
}

