/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialedittext;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.animation.LinearInterpolator;
import me.zhanghai.android.materialedittext.internal.FloatProperty;
import me.zhanghai.android.materialedittext.internal.MathUtils;

class LinearRipple {
    private static final float WAVE_TOUCH_DOWN_ACCELERATION_DP = 1024.0f;
    private static final float WAVE_TOUCH_UP_ACCELERATION_DP = 3400.0f;
    private static final float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static final int RIPPLE_ENTER_DELAY = 80;
    private static final int OPACITY_ENTER_DURATION = 120;
    private static final TimeInterpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final TimeInterpolator DECELERATE_INTERPOLATOR = new LogDecelerateInterpolator(400.0f, 1.4f, 0.0f);
    private final float mWaveTouchDownAcceleration;
    private final float mWaveTouchUpAcceleration;
    private Drawable mOwner;
    private Rect mBounds;
    private float mStartingPosition;
    private float mTargetPosition;
    private float mTargetRadius;
    private float mTweenRipple;
    private float mOpacity = 1.0f;
    private Animator mAnimator;
    private static final FloatProperty<LinearRipple> TWEEN_RIPPLE = new FloatProperty<LinearRipple>("tweenRipple"){

        public Float get(LinearRipple object) {
            return Float.valueOf(object.mTweenRipple);
        }

        @Override
        public void setValue(LinearRipple object, float value) {
            object.mTweenRipple = value;
            object.invalidateSelf();
        }
    };
    private static final FloatProperty<LinearRipple> OPACITY = new FloatProperty<LinearRipple>("opacity"){

        public Float get(LinearRipple object) {
            return Float.valueOf(object.mOpacity);
        }

        @Override
        public void setValue(LinearRipple object, float value) {
            object.mOpacity = value;
            object.invalidateSelf();
        }
    };

    public LinearRipple(Drawable owner, Rect bounds, float position, float density) {
        this.mWaveTouchDownAcceleration = 1024.0f * density;
        this.mWaveTouchUpAcceleration = 3400.0f * density;
        this.mOwner = owner;
        this.onBoundsChange(bounds);
        this.mStartingPosition = position;
    }

    public void onBoundsChange(Rect bounds) {
        this.mBounds = bounds;
        this.mTargetRadius = (float)this.mBounds.width() / 2.0f;
        this.mTargetPosition = (float)this.mBounds.left + this.mTargetRadius;
    }

    public void enter() {
        this.mAnimator = this.createEnterAnimation();
        this.mAnimator.start();
    }

    private int getRippleEnterDuration() {
        return (int)(1000.0 * Math.sqrt(this.mTargetRadius / this.mWaveTouchDownAcceleration) + 0.5);
    }

    private Animator createEnterAnimation() {
        ObjectAnimator tweenRipple = ObjectAnimator.ofFloat((Object)this, TWEEN_RIPPLE, (float[])new float[]{1.0f});
        int duration = this.getRippleEnterDuration();
        tweenRipple.setDuration((long)duration);
        tweenRipple.setInterpolator(LINEAR_INTERPOLATOR);
        tweenRipple.setStartDelay(80L);
        ObjectAnimator opacity = ObjectAnimator.ofFloat((Object)this, OPACITY, (float[])new float[]{1.0f});
        opacity.setDuration(120L);
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)tweenRipple).with((Animator)opacity);
        return set;
    }

    public void moveTo(float position) {
        this.mStartingPosition = position;
    }

    public void fill() {
        this.cancelAnimation();
        if (this.hasFilled()) {
            return;
        }
        this.mAnimator = this.createFillAnimation();
        this.mAnimator.start();
    }

    public boolean hasFilled() {
        return this.mTweenRipple == 1.0f && this.mOpacity == 1.0f;
    }

    private float getCurrentRadius() {
        return MathUtils.lerp(0.0f, this.mTargetRadius, this.mTweenRipple);
    }

    private int getRippleFillOrExitDuration() {
        float radius = this.getCurrentRadius();
        float remaining = this.mTargetRadius - radius;
        return (int)(1000.0 * Math.sqrt(2.0f * remaining / (this.mWaveTouchUpAcceleration + this.mWaveTouchDownAcceleration)) + 0.5);
    }

    private Animator createFillAnimation() {
        ObjectAnimator tweenRipple = ObjectAnimator.ofFloat((Object)this, TWEEN_RIPPLE, (float[])new float[]{1.0f});
        tweenRipple.setDuration((long)this.getRippleFillOrExitDuration());
        tweenRipple.setInterpolator(DECELERATE_INTERPOLATOR);
        return tweenRipple;
    }

    public void makeFilled() {
        this.mTweenRipple = 1.0f;
        this.mOpacity = 1.0f;
        this.invalidateSelf();
    }

    public void exit() {
        this.cancelAnimation();
        if (this.hasExited()) {
            return;
        }
        this.mAnimator = this.createExitAnimation();
        this.mAnimator.start();
    }

    public boolean hasExited() {
        return this.mOpacity == 0.0f;
    }

    private int getOpacityExitDuration() {
        return (int)(1000.0f * this.mOpacity / 3.0f + 0.5f);
    }

    private Animator createExitAnimation() {
        ObjectAnimator opacity = ObjectAnimator.ofFloat((Object)this, OPACITY, (float[])new float[]{0.0f});
        opacity.setDuration((long)this.getOpacityExitDuration());
        opacity.setInterpolator(LINEAR_INTERPOLATOR);
        if (this.hasFilled()) {
            return opacity;
        }
        ObjectAnimator tweenRipple = ObjectAnimator.ofFloat((Object)this, TWEEN_RIPPLE, (float[])new float[]{1.0f});
        tweenRipple.setDuration((long)this.getRippleFillOrExitDuration());
        tweenRipple.setInterpolator(DECELERATE_INTERPOLATOR);
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)tweenRipple).with((Animator)opacity);
        return set;
    }

    public void cancelAnimation() {
        this.stopAnimation(true);
    }

    public void endAnimation() {
        this.stopAnimation(false);
    }

    private void stopAnimation(boolean cancel) {
        if (this.mAnimator == null) {
            return;
        }
        if (cancel) {
            this.mAnimator.cancel();
        } else {
            this.mAnimator.end();
        }
        this.mAnimator = null;
    }

    public void draw(Canvas canvas, Paint paint) {
        int origAlpha = paint.getAlpha();
        int alpha = (int)((float)origAlpha * this.mOpacity + 0.5f);
        float radius = this.getCurrentRadius();
        if (alpha <= 0 || radius <= 0.0f) {
            return;
        }
        float position = MathUtils.lerp(this.mStartingPosition, this.mTargetPosition, this.mTweenRipple);
        float left = MathUtils.constrain(position - radius, (float)this.mBounds.left, (float)this.mBounds.right);
        float right = MathUtils.constrain(position + radius, (float)this.mBounds.left, (float)this.mBounds.right);
        paint.setAlpha(alpha);
        canvas.drawRect(left, (float)this.mBounds.top, right, (float)this.mBounds.bottom, paint);
        paint.setAlpha(origAlpha);
    }

    private void invalidateSelf() {
        this.mOwner.invalidateSelf();
    }

    private static class LogDecelerateInterpolator
    implements TimeInterpolator {
        private float mBase;
        private float mDrift;
        private float mTimeScale;
        private float mOutputScale;

        public LogDecelerateInterpolator(float base, float timeScale, float drift) {
            this.mBase = base;
            this.mDrift = drift;
            this.mTimeScale = 1.0f / timeScale;
            this.mOutputScale = 1.0f / this.computeLog(1.0f);
        }

        private float computeLog(float input) {
            return 1.0f - MathUtils.pow(this.mBase, -input * this.mTimeScale) + this.mDrift * input;
        }

        public float getInterpolation(float input) {
            return this.computeLog(input) * this.mOutputScale;
        }
    }
}

