/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialedittext;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.util.Log;
import me.zhanghai.android.materialedittext.BasePaintDrawable;
import me.zhanghai.android.materialedittext.LinearRipple;
import me.zhanghai.android.materialedittext.R;
import me.zhanghai.android.materialedittext.internal.ThemeUtils;

public class MaterialEditTextBackgroundDrawable
extends BasePaintDrawable {
    private static final String TAG = MaterialEditTextBackgroundDrawable.class.getName();
    private static final int INTRINSIC_WIDTH_DP = 20;
    private static final int INTRINSIC_HEIGHT_DP = 24;
    private static final int INTRINSIC_PADDING_HORIZONTAL = 4;
    private static final int INTRINSIC_PADDING_TOP = 10;
    private static final int INTRINSIC_PADDING_BOTTOM = 11;
    private static final int DRAWING_RECT_TOP_FROM_BOTTOM_DP = 9;
    private static final int DEFAULT_HEIGHT_DP = 1;
    private static final int ACTIVATED_HEIGHT_DP = 2;
    private static final int MAX_RIPPLES = 10;
    private final Rect mPadding;
    private final int mIntrinsicWidth;
    private final int mIntrinsicHeight;
    private final int mDrawingRectTopFromBottom;
    private final int mDefaultHeight;
    private final int mActivatedHeight;
    private final ColorStateList mHintColorList;
    private final float mDisabledAlpha;
    private int mHintColor;
    private float mHintColorAlpha;
    private float mDensity;
    private Rect mDefaultRect = new Rect();
    private Rect mActivatedRect = new Rect();
    private Paint mDefaultPaint;
    private boolean mEnabled;
    private boolean mPressed;
    private boolean mFocused;
    private boolean mError;
    private boolean mHasPendingRipple = false;
    private float mPendingRipplePosition;
    private LinearRipple mEnteringRipple;
    private LinearRipple[] mFillingRipples = new LinearRipple[10];
    private int mFillingRippleCount;
    private LinearRipple mFilledRipple;
    private LinearRipple[] mExitingRipples = new LinearRipple[10];
    private int mExitingRippleCount;

    @SuppressLint(value={"NewApi"})
    public MaterialEditTextBackgroundDrawable(Context context) {
        int colorControlActivated = ThemeUtils.getColorFromAttrRes(R.attr.colorControlActivated, context);
        this.setTint(colorControlActivated);
        Resources resources = context.getResources();
        this.mDensity = resources.getDisplayMetrics().density;
        this.mIntrinsicWidth = (int)(20.0f * this.mDensity + 0.5f);
        this.mIntrinsicHeight = (int)(24.0f * this.mDensity + 0.5f);
        int paddingHorizontal = (int)(4.0f * this.mDensity);
        int paddingTop = (int)(10.0f * this.mDensity);
        int paddingBottom = (int)(11.0f * this.mDensity);
        this.mPadding = new Rect(paddingHorizontal, paddingTop, paddingHorizontal, paddingBottom);
        this.mDrawingRectTopFromBottom = (int)(9.0f * this.mDensity + 0.5f);
        this.mDefaultHeight = (int)(1.0f * this.mDensity + 0.5f);
        this.mActivatedHeight = (int)(2.0f * this.mDensity + 0.5f);
        this.mHintColorList = ThemeUtils.getColorStateListFromAttrRes(16842906, context);
        this.updateHintColor();
        this.mDisabledAlpha = ThemeUtils.getFloatFromAttrRes(0x1010033, context);
    }

    public int getIntrinsicWidth() {
        return this.mIntrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.mIntrinsicHeight;
    }

    public boolean getPadding(@NonNull Rect padding) {
        padding.set(this.mPadding);
        return true;
    }

    protected void onBoundsChange(Rect bounds) {
        int i;
        int drawingRectLeft = bounds.left + this.mPadding.left;
        int drawingRectTop = bounds.bottom - this.mDrawingRectTopFromBottom;
        int drawingRectRight = bounds.right - this.mPadding.right;
        this.mDefaultRect.set(drawingRectLeft, drawingRectTop, drawingRectRight, drawingRectTop + this.mDefaultHeight);
        this.mActivatedRect.set(drawingRectLeft, drawingRectTop, drawingRectRight, drawingRectTop + this.mActivatedHeight);
        if (this.mEnteringRipple != null) {
            this.mEnteringRipple.onBoundsChange(this.mActivatedRect);
        }
        for (i = 0; i < this.mFillingRippleCount; ++i) {
            this.mFillingRipples[i].onBoundsChange(this.mActivatedRect);
        }
        if (this.mFilledRipple != null) {
            this.mFilledRipple.onBoundsChange(this.mActivatedRect);
        }
        for (i = 0; i < this.mExitingRippleCount; ++i) {
            this.mExitingRipples[i].onBoundsChange(this.mActivatedRect);
        }
        this.invalidateSelf();
    }

    @TargetApi(value=21)
    public void getOutline(@NonNull Outline outline) {
        outline.setRect(this.hasRipple() ? this.mActivatedRect : this.mDefaultRect);
    }

    private boolean hasRipple() {
        return this.mEnteringRipple != null || this.mFillingRippleCount > 0 || this.mFilledRipple != null || this.mExitingRippleCount >= 0;
    }

    public void setHotspot(float x, float y) {
        x -= (float)this.mActivatedRect.left;
        if (this.mEnteringRipple == null) {
            this.mPendingRipplePosition = x;
            this.mHasPendingRipple = true;
        } else {
            this.mEnteringRipple.moveTo(x);
        }
    }

    public boolean hasError() {
        return this.mError;
    }

    public void setError(boolean error) {
        if (this.mError != error) {
            this.mError = error;
            this.onStateChanged();
        }
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        this.updateHintColor();
        this.mEnabled = false;
        this.mPressed = false;
        this.mFocused = false;
        block5: for (int state : stateSet) {
            switch (state) {
                case 16842910: {
                    this.mEnabled = true;
                    continue block5;
                }
                case 16842919: {
                    this.mPressed = true;
                    continue block5;
                }
                case 16842908: {
                    this.mFocused = true;
                }
            }
        }
        this.onStateChanged();
        return true;
    }

    private void updateHintColor() {
        this.mHintColor = this.mHintColorList.getColorForState(this.getState(), 0);
        this.mHintColorAlpha = (float)Color.alpha((int)this.mHintColor) / 255.0f;
    }

    private void onStateChanged() {
        this.updateRipples();
        if (!this.mEnabled || !this.mPressed && !this.mFocused && !this.mError) {
            this.exitRipples();
        } else if (this.mPressed) {
            if (this.mEnteringRipple == null && this.mFilledRipple == null) {
                this.createAndEnterRipple();
            }
        } else {
            if (this.mEnteringRipple != null) {
                this.fillEnteringRipple();
            }
            if (this.mFillingRippleCount == 0 && this.mFilledRipple == null) {
                this.createFillingRipple();
            }
        }
        this.invalidateSelf();
    }

    private void removeEnteringRipple() {
        if (this.mEnteringRipple != null) {
            this.mEnteringRipple.endAnimation();
            this.mEnteringRipple = null;
        }
    }

    private void removeFillingRipples() {
        for (int i = 0; i < this.mFillingRippleCount; ++i) {
            this.mFillingRipples[i].endAnimation();
            this.mFillingRipples[i] = null;
        }
        this.mFillingRippleCount = 0;
    }

    private void removeFilledRipple() {
        this.mFilledRipple = null;
    }

    private void removeExitingRipples() {
        for (int i = 0; i < this.mExitingRippleCount; ++i) {
            this.mExitingRipples[i].endAnimation();
            this.mExitingRipples[i] = null;
        }
        this.mExitingRippleCount = 0;
    }

    private void updateRipples() {
        if (this.mFilledRipple == null && this.mEnteringRipple != null && this.mEnteringRipple.hasFilled()) {
            this.mFilledRipple = this.mEnteringRipple;
        }
        if (this.mFilledRipple == null) {
            for (int i = 0; i < this.mFillingRippleCount; ++i) {
                LinearRipple fillingRipple = this.mFillingRipples[i];
                if (!fillingRipple.hasFilled()) continue;
                this.mFilledRipple = this.mFillingRipples[i];
                break;
            }
        }
        if (this.mFilledRipple != null) {
            this.removeEnteringRipple();
            this.removeFillingRipples();
            this.removeExitingRipples();
        } else {
            int i;
            int remaining = 0;
            for (i = 0; i < this.mExitingRippleCount; ++i) {
                if (this.mExitingRipples[i].hasExited()) continue;
                this.mExitingRipples[remaining++] = this.mExitingRipples[i];
            }
            for (i = remaining; i < this.mExitingRippleCount; ++i) {
                this.mExitingRipples[i] = null;
            }
            this.mExitingRippleCount = remaining;
        }
    }

    private void exitRipple(LinearRipple ripple) {
        ripple.exit();
        this.mExitingRipples[this.mExitingRippleCount++] = ripple;
    }

    private void exitRipples() {
        if (this.mEnteringRipple != null) {
            this.exitRipple(this.mEnteringRipple);
            this.mEnteringRipple = null;
        }
        for (int i = 0; i < this.mFillingRippleCount; ++i) {
            this.exitRipple(this.mFillingRipples[i]);
            this.mFillingRipples[i] = null;
        }
        this.mFillingRippleCount = 0;
        if (this.mFilledRipple != null) {
            this.exitRipple(this.mFilledRipple);
            this.mFilledRipple = null;
        }
    }

    private LinearRipple createRipple() {
        float position;
        int rippleCount = 0;
        if (this.mEnteringRipple != null) {
            ++rippleCount;
        }
        rippleCount += this.mFillingRippleCount;
        if (this.mFilledRipple != null) {
            ++rippleCount;
        }
        if ((rippleCount += this.mExitingRippleCount) >= 10) {
            Log.w((String)TAG, (String)"Too many ripples alive, skipping ripple creation");
            return null;
        }
        if (this.mHasPendingRipple) {
            this.mHasPendingRipple = false;
            position = this.mPendingRipplePosition;
        } else {
            position = this.mActivatedRect.exactCenterX();
        }
        return new LinearRipple(this, this.mActivatedRect, position, this.mDensity);
    }

    private void createAndEnterRipple() {
        this.mEnteringRipple = this.createRipple();
        if (this.mEnteringRipple != null) {
            this.mEnteringRipple.enter();
        }
    }

    private void fillRipple(LinearRipple ripple) {
        ripple.fill();
        this.mFillingRipples[this.mFillingRippleCount++] = ripple;
    }

    private void fillEnteringRipple() {
        if (this.mEnteringRipple == null) {
            throw new IllegalStateException("fillEnteringRipple() when mEnteringRipple is not null");
        }
        this.fillRipple(this.mEnteringRipple);
        this.mEnteringRipple = null;
    }

    private void createFillingRipple() {
        LinearRipple ripple = this.createRipple();
        if (ripple != null) {
            this.fillRipple(ripple);
        }
    }

    public void jumpToCurrentState() {
        this.updateRipples();
        this.removeEnteringRipple();
        this.removeFillingRipples();
        this.removeExitingRipples();
        if (this.mEnabled && (this.mPressed || this.mFocused)) {
            if (this.mFilledRipple == null) {
                this.createFilledRipple();
            }
        } else {
            this.removeFilledRipple();
        }
        this.invalidateSelf();
    }

    private void createFilledRipple() {
        LinearRipple ripple = this.createRipple();
        if (ripple != null) {
            ripple.makeFilled();
            this.mFilledRipple = ripple;
        }
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.updateRipples();
        boolean changed = super.setVisible(visible, restart);
        if (changed && !visible) {
            this.jumpToCurrentState();
        }
        return changed;
    }

    @Override
    protected void onDraw(Canvas canvas, int width, int height, Paint paint) {
        this.drawDefault(canvas);
        this.drawRipples(canvas, paint);
    }

    private void drawDefault(Canvas canvas) {
        if (this.mDefaultPaint == null) {
            this.mDefaultPaint = new Paint();
            this.mDefaultPaint.setAntiAlias(true);
            this.mDefaultPaint.setColor(this.mHintColor);
        }
        int alpha = (int)((this.mEnabled ? 1.0f : this.mDisabledAlpha) * this.mHintColorAlpha * (float)this.mAlpha + 0.5f);
        this.mDefaultPaint.setAlpha(alpha);
        canvas.drawRect(this.mDefaultRect, this.mDefaultPaint);
    }

    @Override
    protected void onPreparePaint(Paint paint) {
        paint.setStyle(Paint.Style.FILL);
    }

    private void drawRipples(Canvas canvas, Paint paint) {
        this.updateRipples();
        if (this.mFilledRipple != null) {
            this.mFilledRipple.draw(canvas, paint);
        } else {
            int i;
            for (i = 0; i < this.mExitingRippleCount; ++i) {
                this.mExitingRipples[i].draw(canvas, paint);
            }
            for (i = 0; i < this.mFillingRippleCount; ++i) {
                this.mFillingRipples[i].draw(canvas, paint);
            }
            if (this.mEnteringRipple != null) {
                this.mEnteringRipple.draw(canvas, paint);
            }
        }
    }
}

