/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.materialprogressbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Px;
import me.zhanghai.android.materialprogressbar.BaseProgressDrawable;
import me.zhanghai.android.materialprogressbar.R;
import me.zhanghai.android.materialprogressbar.internal.ThemeUtils;

public class StaticIndeterminateCircularProgressDrawable
extends BaseProgressDrawable {
    private static final Path PATH_PROGRESS = new Path();
    @Dimension(unit=0)
    private static final int PROGRESS_INTRINSIC_SIZE_DP = 42;
    @Dimension(unit=0)
    private static final int PADDED_INTRINSIC_SIZE_DP = 48;
    private static final RectF RECT_PROGRESS_BOUND;
    private static final RectF RECT_PADDED_BOUND;
    @Px
    private final int mProgressIntrinsicSize;
    @Px
    private final int mPaddedIntrinsicSize;
    @NonNull
    private final Path mPath = new Path();
    @NonNull
    private final Matrix mMatrix = new Matrix();

    public StaticIndeterminateCircularProgressDrawable(@NonNull Context context) {
        float density = context.getResources().getDisplayMetrics().density;
        this.mProgressIntrinsicSize = Math.round(42.0f * density);
        this.mPaddedIntrinsicSize = Math.round(48.0f * density);
        int controlActivatedColor = ThemeUtils.getColorFromAttrRes(R.attr.colorControlActivated, -16777216, context);
        this.setTint(controlActivatedColor);
    }

    @Px
    private int getIntrinsicSize() {
        return this.mUseIntrinsicPadding ? this.mPaddedIntrinsicSize : this.mProgressIntrinsicSize;
    }

    @Px
    public int getIntrinsicWidth() {
        return this.getIntrinsicSize();
    }

    @Px
    public int getIntrinsicHeight() {
        return this.getIntrinsicSize();
    }

    @Override
    protected void onPreparePaint(@NonNull Paint paint) {
        paint.setStyle(Paint.Style.FILL);
    }

    @Override
    protected void onDraw(@NonNull Canvas canvas, int width, int height, @NonNull Paint paint) {
        RectF bound = this.mUseIntrinsicPadding ? RECT_PADDED_BOUND : RECT_PROGRESS_BOUND;
        this.mMatrix.setScale((float)width / bound.width(), (float)height / bound.height());
        this.mMatrix.preTranslate(-bound.left, -bound.top);
        PATH_PROGRESS.transform(this.mMatrix, this.mPath);
        canvas.drawPath(this.mPath, paint);
    }

    static {
        PATH_PROGRESS.moveTo(17.65f, 6.35f);
        PATH_PROGRESS.cubicTo(16.2f, 4.9f, 14.21f, 4.0f, 12.0f, 4.0f);
        PATH_PROGRESS.cubicTo(7.58f, 4.0f, 4.01f, 7.58f, 4.01f, 12.0f);
        PATH_PROGRESS.rCubicTo(0.0f, 4.42f, 3.57f, 8.0f, 7.99f, 8.0f);
        PATH_PROGRESS.rCubicTo(3.73f, 0.0f, 6.84f, -2.55f, 7.73f, -6.0f);
        PATH_PROGRESS.rLineTo(-2.08f, 0.0f);
        PATH_PROGRESS.cubicTo(16.83f, 16.33f, 14.61f, 18.0f, 12.0f, 18.0f);
        PATH_PROGRESS.cubicTo(8.69f, 18.0f, 6.0f, 15.31f, 6.0f, 12.0f);
        PATH_PROGRESS.cubicTo(6.0f, 8.69f, 8.69f, 6.0f, 12.0f, 6.0f);
        PATH_PROGRESS.rCubicTo(1.66f, 0.0f, 3.1f, 0.69f, 4.22f, 1.78f);
        PATH_PROGRESS.lineTo(13.0f, 11.0f);
        PATH_PROGRESS.rLineTo(7.0f, 0.0f);
        PATH_PROGRESS.lineTo(20.0f, 4.0f);
        PATH_PROGRESS.close();
        RECT_PROGRESS_BOUND = new RectF(3.0f, 3.0f, 21.0f, 21.0f);
        RECT_PADDED_BOUND = new RectF(0.0f, 0.0f, 24.0f, 24.0f);
    }
}

