/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.systemuihelper;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import me.zhanghai.android.systemuihelper.SystemUiHelperImplHC;
import me.zhanghai.android.systemuihelper.SystemUiHelperImplICS;
import me.zhanghai.android.systemuihelper.SystemUiHelperImplJB;
import me.zhanghai.android.systemuihelper.SystemUiHelperImplKK;

public final class SystemUiHelper {
    public static final int LEVEL_LOW_PROFILE = 0;
    public static final int LEVEL_HIDE_STATUS_BAR = 1;
    public static final int LEVEL_LEAN_BACK = 2;
    public static final int LEVEL_IMMERSIVE = 3;
    public static final int FLAG_LAYOUT_IN_SCREEN_OLDER_DEVICES = 1;
    public static final int FLAG_IMMERSIVE_STICKY = 2;
    private static final String LOG_TAG = SystemUiHelper.class.getSimpleName();
    private final SystemUiHelperImpl mImpl;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Runnable mHideRunnable = new HideRunnable();

    public SystemUiHelper(Activity activity, int level, int flags) {
        this(activity, level, flags, null);
    }

    public SystemUiHelper(Activity activity, int level, int flags, OnVisibilityChangeListener listener) {
        this.mImpl = Build.VERSION.SDK_INT >= 19 ? new SystemUiHelperImplKK(activity, level, flags, listener) : (Build.VERSION.SDK_INT >= 16 ? new SystemUiHelperImplJB(activity, level, flags, listener) : (Build.VERSION.SDK_INT >= 14 ? new SystemUiHelperImplICS(activity, level, flags, listener) : (Build.VERSION.SDK_INT >= 11 ? new SystemUiHelperImplHC(activity, level, flags, listener) : new SystemUiHelperImplBase(activity, level, flags, listener))));
    }

    public boolean isShowing() {
        return this.mImpl.isShowing();
    }

    public void show() {
        this.removeQueuedRunnables();
        this.mImpl.show();
    }

    public void hide() {
        this.removeQueuedRunnables();
        this.mImpl.hide();
    }

    public void delayHide(long delayMillis) {
        this.removeQueuedRunnables();
        this.mHandler.postDelayed(this.mHideRunnable, delayMillis);
    }

    public void toggle() {
        if (this.isShowing()) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void removeQueuedRunnables() {
        this.mHandler.removeCallbacks(this.mHideRunnable);
    }

    private class HideRunnable
    implements Runnable {
        private HideRunnable() {
        }

        @Override
        public void run() {
            SystemUiHelper.this.hide();
        }
    }

    static class SystemUiHelperImplBase
    extends SystemUiHelperImpl {
        SystemUiHelperImplBase(Activity activity, int level, int flags, OnVisibilityChangeListener onVisibilityChangeListener) {
            super(activity, level, flags, onVisibilityChangeListener);
            if ((this.mFlags & 1) != 0) {
                this.mActivity.getWindow().addFlags(768);
            }
        }

        @Override
        void show() {
            if (this.mLevel > 0) {
                this.mActivity.getWindow().clearFlags(1024);
                this.setIsShowing(true);
            }
        }

        @Override
        void hide() {
            if (this.mLevel > 0) {
                this.mActivity.getWindow().addFlags(1024);
                this.setIsShowing(false);
            }
        }
    }

    static abstract class SystemUiHelperImpl {
        final Activity mActivity;
        final int mLevel;
        final int mFlags;
        final OnVisibilityChangeListener mOnVisibilityChangeListener;
        boolean mIsShowing = true;

        SystemUiHelperImpl(Activity activity, int level, int flags, OnVisibilityChangeListener onVisibilityChangeListener) {
            this.mActivity = activity;
            this.mLevel = level;
            this.mFlags = flags;
            this.mOnVisibilityChangeListener = onVisibilityChangeListener;
        }

        abstract void show();

        abstract void hide();

        boolean isShowing() {
            return this.mIsShowing;
        }

        void setIsShowing(boolean isShowing) {
            this.mIsShowing = isShowing;
            if (this.mOnVisibilityChangeListener != null) {
                this.mOnVisibilityChangeListener.onVisibilityChange(this.mIsShowing);
            }
        }
    }

    public static interface OnVisibilityChangeListener {
        public void onVisibilityChange(boolean var1);
    }
}

