/*
 * Decompiled with CFR 0.152.
 */
package me.zhanghai.android.systemuihelper;

import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.view.View;
import me.zhanghai.android.systemuihelper.SystemUiHelper;

@TargetApi(value=11)
class SystemUiHelperImplHC
extends SystemUiHelper.SystemUiHelperImpl
implements View.OnSystemUiVisibilityChangeListener {
    final View mDecorView;

    SystemUiHelperImplHC(Activity activity, int level, int flags, SystemUiHelper.OnVisibilityChangeListener onVisibilityChangeListener) {
        super(activity, level, flags, onVisibilityChangeListener);
        this.mDecorView = activity.getWindow().getDecorView();
        this.mDecorView.setOnSystemUiVisibilityChangeListener((View.OnSystemUiVisibilityChangeListener)this);
    }

    @Override
    void show() {
        this.mDecorView.setSystemUiVisibility(this.createShowFlags());
        this.mDecorView.requestLayout();
    }

    @Override
    void hide() {
        this.mDecorView.setSystemUiVisibility(this.createHideFlags());
        this.mDecorView.requestLayout();
    }

    public final void onSystemUiVisibilityChange(int visibility) {
        if ((visibility & this.createTestFlags()) != 0) {
            this.onSystemUiHidden();
        } else {
            this.onSystemUiShown();
        }
    }

    protected void onSystemUiShown() {
        ActionBar ab = this.mActivity.getActionBar();
        if (ab != null) {
            ab.show();
        }
        this.mActivity.getWindow().clearFlags(1024);
        this.setIsShowing(true);
    }

    protected void onSystemUiHidden() {
        ActionBar ab = this.mActivity.getActionBar();
        if (ab != null) {
            ab.hide();
        }
        this.mActivity.getWindow().addFlags(1024);
        this.setIsShowing(false);
    }

    protected int createShowFlags() {
        return 0;
    }

    protected int createHideFlags() {
        return 1;
    }

    protected int createTestFlags() {
        return 1;
    }
}

