/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.devapi;

import com.mysql.cj.api.x.SqlResult;
import com.mysql.cj.api.x.SqlStatement;
import com.mysql.cj.core.exceptions.FeatureNotAvailableException;
import com.mysql.cj.mysqlx.ExprUtil;
import com.mysql.cj.mysqlx.devapi.NodeSessionImpl;
import com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class SqlStatementImpl
implements SqlStatement {
    private NodeSessionImpl session;
    private String sql;
    private List<MysqlxDatatypes.Any> args = new ArrayList<MysqlxDatatypes.Any>();

    public SqlStatementImpl(NodeSessionImpl session, String sql) {
        this.session = session;
        this.sql = sql;
    }

    @Override
    public SqlResult execute() {
        return this.session.getMysqlxSession().executeSql(this.sql, this.args);
    }

    @Override
    public CompletableFuture<SqlResult> executeAsync() {
        return this.session.getMysqlxSession().asyncExecuteSql(this.sql, this.args);
    }

    @Override
    public SqlStatement clearBindings() {
        this.args.clear();
        return this;
    }

    @Override
    public SqlStatement bind(List<Object> values) {
        values.stream().map(ExprUtil::argObjectToScalarAny).forEach(a -> this.args.add((MysqlxDatatypes.Any)a));
        return this;
    }

    @Override
    public SqlStatement bind(Map<String, Object> values) {
        throw new FeatureNotAvailableException("Cannot bind named parameters for SQL statements");
    }
}

