/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.mvp;

import android.content.Context;
import android.text.TextUtils;
import java.lang.reflect.Field;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.utils.SpUtil;

public abstract class AbsRepository
implements IRepository {
    protected Context mContext;
    protected SpUtil mSp;

    public AbsRepository(Context context) {
        this.mContext = context;
        this.mSp = SpUtil.getInstance();
    }

    protected void doSave(String key, Object value) {
        this.mSp.put(key, value);
    }

    protected void updateUserProfile(String field, String update) {
        this.updateValue(UserProfile.class, field, update);
    }

    protected void updateAPI(String field, String update) {
        if (TextUtils.isEmpty((CharSequence)update)) {
            return;
        }
        this.updateValue(API.class, field, update);
    }

    protected void updateConst(String field, Object update) {
        this.updateValue(Const.class, field, update);
    }

    private void updateValue(Class clazz, String field, Object update) {
        try {
            String[] split = field.split("\\.");
            Field originField = clazz.getDeclaredField(split[1]);
            originField.setAccessible(true);
            if (update != null) {
                originField.set(null, update);
            } else if ("String".equals(originField.getType().getSimpleName())) {
                originField.set(null, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

