/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http.config;

import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.FileProgressRequestBody;
import net.aihelp.core.net.http.config.Tls12SocketFactory;
import net.aihelp.core.net.http.interceptor.HeaderInterceptor;
import net.aihelp.core.net.http.interceptor.LogInterceptor;
import net.aihelp.core.net.http.interceptor.SignInterceptor;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.TlsVersion;

public class HttpConfig {
    public static final MediaType MEDIA_TYPE_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType MEDIA_OBJECT_STREAM = MediaType.parse((String)"application/octet-stream");
    private static final int TIME_OUT_LIMIT = 60;
    private static final ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.COMPATIBLE_TLS).supportsTlsExtensions(true).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0}).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_ECDHE_ECDSA_WITH_RC4_128_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_RC4_128_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_DHE_DSS_WITH_AES_128_CBC_SHA, CipherSuite.TLS_DHE_RSA_WITH_AES_256_CBC_SHA}).build();

    public static OkHttpClient getOkHttpClient(boolean isAddHeader) {
        List<ConnectionSpec> specsList;
        OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).hostnameVerifier(HttpConfig.createInsecureHostnameVerifier()).cookieJar(new CookieJar(){
            private final HashMap<HttpUrl, List<Cookie>> cookieStore = new HashMap();

            public void saveFromResponse(@NonNull HttpUrl url, @NonNull List<Cookie> cookies) {
                this.cookieStore.put(url, cookies);
            }

            @NonNull
            public List<Cookie> loadForRequest(@NonNull HttpUrl url) {
                ArrayList cookies = this.cookieStore.get(url);
                return cookies != null ? cookies : new ArrayList();
            }
        });
        if (isAddHeader) {
            clientBuilder.addInterceptor((Interceptor)new HeaderInterceptor());
        }
        clientBuilder.addInterceptor((Interceptor)new LogInterceptor());
        clientBuilder.addInterceptor((Interceptor)new SignInterceptor());
        clientBuilder.connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, spec));
        if (Build.VERSION.SDK_INT < 22 && (specsList = HttpConfig.getSpecsBelowLollipopMR1(clientBuilder)) != null) {
            clientBuilder.connectionSpecs(specsList);
        }
        return clientBuilder.build();
    }

    private static List<ConnectionSpec> getSpecsBelowLollipopMR1(OkHttpClient.Builder okb) {
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, null, null);
            okb.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sc.getSocketFactory()));
            ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
            ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
            specs.add(cs);
            specs.add(ConnectionSpec.COMPATIBLE_TLS);
            return specs;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static HostnameVerifier createInsecureHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return hostname.contains("aihelp");
            }
        };
    }

    public static Request getUploadRequest(String url, File file) {
        String formData = null;
        try {
            formData = String.format("form-data;name=file;filename=%s", URLEncoder.encode(file.getName(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (formData == null) {
            return null;
        }
        FileProgressRequestBody filePart = new FileProgressRequestBody(MultipartBody.FORM, file, null);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addPart(Headers.of((String[])new String[]{"Content-Disposition", formData}), (RequestBody)filePart);
        if (url.contains(API.UPLOAD_VIDEO_URL) || url.contains(API.UPLOAD_LOG_URL) || url.contains(API.UPLOAD_IMAGE_URL) || url.contains(API.UPLOAD_ATTACHMENT_URL)) {
            String randomValue = String.valueOf(new Random().nextInt(Integer.MAX_VALUE));
            String timeStamp = String.valueOf(System.currentTimeMillis());
            requestBodyBuilder.addFormDataPart("appId", Const.APP_ID).addFormDataPart("random", randomValue).addFormDataPart("timespan", timeStamp).addFormDataPart("userId", UserProfile.USER_ID).addFormDataPart("siga", HttpConfig.getUploadVideoSig(randomValue, timeStamp));
        }
        MultipartBody body = requestBodyBuilder.build();
        return new Request.Builder().url(url).post((RequestBody)body).build();
    }

    private static String getUploadVideoSig(String randomValue, String timeStamp) {
        String source = "appId_" + Const.APP_ID + "random_" + randomValue + "timespan_" + timeStamp + "userId_" + UserProfile.USER_ID;
        return HttpConfig.md5(source);
    }

    public static String md5(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            byte[] hash;
            try {
                hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
                hash = new byte[2];
            }
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            return hex.toString();
        }
        return "";
    }
}

