/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http.config;

import androidx.annotation.Nullable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import net.aihelp.utils.TLog;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Protocol;

public class HttpEventListener
extends EventListener {
    public static final EventListener.Factory FACTORY = new EventListener.Factory(){
        final AtomicLong nextCallId = new AtomicLong(1L);

        public EventListener create(Call call) {
            long callId = this.nextCallId.getAndIncrement();
            return new HttpEventListener(callId, call.request().url(), System.nanoTime());
        }
    };
    private final long callId;
    private final long callStartNanos;
    private StringBuilder sbLog;

    public HttpEventListener(long callId, HttpUrl url, long callStartNanos) {
        this.callId = callId;
        this.callStartNanos = callStartNanos;
        this.sbLog = new StringBuilder(url.toString()).append(" ").append(callId).append(":");
    }

    private void recordEventLog(String name) {
        long elapseNanos = System.nanoTime() - this.callStartNanos;
        this.sbLog.append(String.format(Locale.CHINA, "%.3f-%s", (double)elapseNanos / 1.0E9, name)).append(";");
        if (name.equalsIgnoreCase("callEnd") || name.equalsIgnoreCase("callFailed")) {
            TLog.d("okhttp", this.sbLog.toString());
        }
    }

    public void callStart(Call call) {
        super.callStart(call);
        this.recordEventLog("callStart");
    }

    public void callFailed(Call call, IOException ioe) {
        super.callFailed(call, ioe);
        this.recordEventLog("callFailed " + ioe.getMessage());
    }

    public void dnsStart(Call call, String domainName) {
        super.dnsStart(call, domainName);
        this.recordEventLog("dnsStart");
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        super.dnsEnd(call, domainName, inetAddressList);
        this.recordEventLog("dnsEnd");
        TLog.d("okhttp", Arrays.toString(inetAddressList.toArray()));
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        super.connectStart(call, inetSocketAddress, proxy);
        this.recordEventLog("connectStart");
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        this.recordEventLog("connectEnd");
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException ioe) {
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        this.recordEventLog("connectFailed");
    }
}

