/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.callback;

import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.net.mqtt.client.Callback;

public class SubscribeCallback
implements Callback<byte[]> {
    private final boolean isFaqRequest;
    private final IMqttCallback mqttCallback;
    private final int connectionId;
    private final int connectionType;

    public SubscribeCallback(boolean isFaqRequest, IMqttCallback callback, int connectionId, int connectionType) {
        this.isFaqRequest = isFaqRequest;
        this.mqttCallback = callback;
        this.connectionId = connectionId;
        this.connectionType = connectionType;
    }

    @Override
    public void onSuccess(byte[] value) {
        if (this.isFaqRequest) {
            return;
        }
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId()) {
            this.mqttCallback.dismissMqttLoading();
            this.mqttCallback.onMqttSubscribed(this.connectionType);
        }
    }

    @Override
    public void onFailure(Throwable value) {
        if (this.connectionId == AIHelpMqtt.getInstance().getMqttConnectionId() && this.mqttCallback != null) {
            this.mqttCallback.onMqttFailure();
        }
    }
}

