/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.tansport;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.aihelp.core.net.mqtt.hawtdispatch.CustomDispatchSource;
import net.aihelp.core.net.mqtt.hawtdispatch.Dispatch;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.EventAggregators;
import net.aihelp.core.net.mqtt.hawtdispatch.Retained;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.TaskWrapper;
import net.aihelp.core.net.mqtt.tansport.PipeTransportServer;
import net.aihelp.core.net.mqtt.tansport.ProtocolCodec;
import net.aihelp.core.net.mqtt.tansport.Transport;
import net.aihelp.core.net.mqtt.tansport.TransportListener;

public class PipeTransport
implements Transport {
    private static final Object EOF_TOKEN = new Object();
    private final PipeTransportServer server;
    PipeTransport peer;
    private TransportListener listener;
    private SocketAddress remoteAddress;
    private AtomicBoolean stopping = new AtomicBoolean();
    private String name;
    private boolean marshal;
    private boolean trace;
    private DispatchQueue dispatchQueue;
    private CustomDispatchSource<Object, LinkedList<Object>> dispatchSource;
    private boolean connected;
    private long writeCounter = 0L;
    private long readCounter = 0L;
    private ProtocolCodec protocolCodec;
    int outbound = 0;
    int maxOutbound = 100;

    public PipeTransport(PipeTransportServer server) {
        this.server = server;
    }

    @Override
    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    @Override
    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
    }

    @Override
    @Deprecated
    public void start(Runnable onCompleted) {
        this.start(new TaskWrapper(onCompleted));
    }

    @Override
    public void start(final Task onCompleted) {
        if (this.dispatchQueue == null) {
            throw new IllegalArgumentException("dispatchQueue is not set");
        }
        this.server.dispatchQueue.execute(new Task(){

            @Override
            public void run() {
                PipeTransport.this.dispatchSource = Dispatch.createSource(EventAggregators.linkedList(), PipeTransport.this.dispatchQueue);
                PipeTransport.this.dispatchSource.setEventHandler(new Task(){

                    @Override
                    public void run() {
                        try {
                            final LinkedList commands = (LinkedList)PipeTransport.this.dispatchSource.getData();
                            for (Object o : commands) {
                                if (o == EOF_TOKEN) {
                                    throw new EOFException();
                                }
                                PipeTransport.this.readCounter++;
                                PipeTransport.this.listener.onTransportCommand(o);
                            }
                            PipeTransport.this.peer.dispatchQueue.execute(new Task(){

                                @Override
                                public void run() {
                                    PipeTransport.this.outbound -= commands.size();
                                    PipeTransport.this.drainInbound();
                                }
                            });
                        }
                        catch (IOException e) {
                            PipeTransport.this.listener.onTransportFailure(e);
                        }
                    }
                });
                if (PipeTransport.this.peer.dispatchSource != null) {
                    PipeTransport.this.fireConnected();
                    PipeTransport.this.peer.fireConnected();
                }
                if (onCompleted != null) {
                    onCompleted.run();
                }
            }
        });
    }

    private void fireConnected() {
        this.dispatchQueue.execute(new Task(){

            @Override
            public void run() {
                PipeTransport.this.connected = true;
                PipeTransport.this.dispatchSource.resume();
                PipeTransport.this.listener.onTransportConnected();
                PipeTransport.this.drainInbound();
            }
        });
    }

    @Override
    public void flush() {
        this.listener.onRefill();
    }

    @Override
    @Deprecated
    public void stop(Runnable onCompleted) {
        this.stop(new TaskWrapper(onCompleted));
    }

    @Override
    public void stop(Task onCompleted) {
        if (this.connected) {
            this.peer.dispatchSource.merge(EOF_TOKEN);
        }
        if (this.dispatchSource != null) {
            this.dispatchSource.setCancelHandler(onCompleted);
            this.dispatchSource.cancel();
        }
        this.setDispatchQueue(null);
    }

    @Override
    public boolean full() {
        return this.outbound >= this.maxOutbound;
    }

    @Override
    public boolean offer(Object command) {
        if (!this.connected) {
            return false;
        }
        if (this.full()) {
            return false;
        }
        this.transmit(command);
        return true;
    }

    @Override
    public void drainInbound() {
        if (!this.full()) {
            this.listener.onRefill();
        }
    }

    private void transmit(Object command) {
        ++this.writeCounter;
        ++this.outbound;
        this.peer.dispatchSource.merge(command);
    }

    public long getWriteCounter() {
        return this.writeCounter;
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void suspendRead() {
        this.dispatchSource.suspend();
    }

    @Override
    public void resumeRead() {
        this.dispatchSource.resume();
    }

    public void setRemoteAddress(final String remoteAddress) {
        this.remoteAddress = new SocketAddress(){

            public String toString() {
                return remoteAddress;
            }
        };
        if (this.name == null) {
            this.name = remoteAddress;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TransportListener getTransportListener() {
        return this.listener;
    }

    @Override
    public void setTransportListener(TransportListener transportListener) {
        this.listener = transportListener;
    }

    @Override
    public ProtocolCodec getProtocolCodec() {
        return this.protocolCodec;
    }

    @Override
    public void setProtocolCodec(ProtocolCodec protocolCodec) {
        this.protocolCodec = protocolCodec;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshall) {
        this.marshal = marshall;
    }

    @Override
    public boolean isConnected() {
        return !this.stopping.get();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Executor getBlockingExecutor() {
        return null;
    }

    @Override
    public void setBlockingExecutor(Executor blockingExecutor) {
    }

    @Override
    public ReadableByteChannel getReadChannel() {
        return null;
    }

    @Override
    public WritableByteChannel getWriteChannel() {
        return null;
    }

    static final class OneWay {
        final Object command;
        final Retained retained;

        public OneWay(Object command, Retained retained) {
            this.command = command;
            this.retained = retained;
        }
    }
}

