/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.tansport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.Executor;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.tansport.ServiceBase;
import net.aihelp.core.net.mqtt.tansport.TransportServer;
import net.aihelp.core.net.mqtt.tansport.TransportServerListener;
import net.aihelp.core.net.mqtt.tansport.UdpTransport;

public class UdpTransportServer
extends ServiceBase
implements TransportServer {
    private final String bindScheme;
    private final InetSocketAddress bindAddress;
    private DatagramChannel channel;
    private TransportServerListener listener;
    private DispatchQueue dispatchQueue;
    private Executor blockingExecutor;
    private UdpTransport transport;

    public UdpTransportServer(URI location) throws UnknownHostException {
        this.bindScheme = location.getScheme();
        String host = location.getHost();
        host = host == null || host.length() == 0 ? "::" : host;
        this.bindAddress = new InetSocketAddress(InetAddress.getByName(host), location.getPort());
    }

    @Override
    public void setTransportServerListener(TransportServerListener listener) {
        this.listener = listener;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
    }

    @Override
    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    @Override
    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
    }

    @Override
    protected void _start(Task onCompleted) {
        this.accept();
        if (onCompleted != null) {
            this.dispatchQueue.execute(onCompleted);
        }
    }

    private void queueAccept() {
        this.dispatchQueue.execute(new Task(){

            @Override
            public void run() {
                UdpTransportServer.this.accept();
            }
        });
    }

    private void accept() {
        if (this.getServiceState().isStarted() || this.getServiceState().isStarting()) {
            try {
                UdpTransport udpTransport;
                this.transport = udpTransport = this.createTransport();
                this.transport.onDispose = new Task(){

                    @Override
                    public void run() {
                        UdpTransportServer.this.queueAccept();
                    }
                };
                this.channel = DatagramChannel.open();
                this.channel.socket().bind(this.bindAddress);
                this.transport.connected(this.channel);
                this.listener.onAccept(this.transport);
            }
            catch (Exception e) {
                this.listener.onAcceptError(e);
            }
        }
    }

    protected UdpTransport createTransport() {
        UdpTransport transport = new UdpTransport();
        transport.setBlockingExecutor(this.blockingExecutor);
        transport.setDispatchQueue(this.dispatchQueue);
        return transport;
    }

    @Override
    protected void _stop(Task onCompleted) {
        this.transport.stop(onCompleted);
    }

    @Override
    public void suspend() {
        this.dispatchQueue.suspend();
    }

    @Override
    public void resume() {
        this.dispatchQueue.resume();
    }

    @Override
    public String getBoundAddress() {
        try {
            String host = this.bindAddress.getAddress().getHostAddress();
            int port = this.channel.socket().getLocalPort();
            return new URI(this.bindScheme, null, host, port, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getBoundAddress();
    }

    @Override
    public Executor getBlockingExecutor() {
        return this.blockingExecutor;
    }

    @Override
    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }
}

