/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.aihelp.core.ui.BaseActivity;

public enum ActivityManager {
    INSTANCE;

    private final List<WeakReference<BaseActivity>> sActivityList = new ArrayList<WeakReference<BaseActivity>>();

    public void register(BaseActivity activity) {
        this.sActivityList.add(new WeakReference<BaseActivity>(activity));
    }

    public void unregister(BaseActivity activity) {
        Iterator<WeakReference<BaseActivity>> iterator = this.sActivityList.iterator();
        while (iterator.hasNext()) {
            BaseActivity baseActivity;
            WeakReference<BaseActivity> activityRef = iterator.next();
            if (activityRef == null || activityRef.get() == null || (baseActivity = (BaseActivity)((Object)activityRef.get())) != activity) continue;
            iterator.remove();
        }
    }

    public void finishAll() {
        for (int i = this.sActivityList.size() - 1; i >= 0; --i) {
            WeakReference<BaseActivity> activityRef = this.sActivityList.get(i);
            if (activityRef == null || activityRef.get() == null) continue;
            ((BaseActivity)((Object)activityRef.get())).finish();
        }
    }
}

