/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.mvp.IPresenter;
import net.aihelp.core.mvp.IView;
import net.aihelp.core.net.monitor.NetworkState;
import net.aihelp.core.ui.loading.helper.VaryViewHelperController;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.ui.SupportFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.helper.FragmentHelper;
import net.aihelp.ui.wrapper.FaqEventListenerWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

public abstract class BaseFragment<P extends IPresenter>
extends Fragment
implements IView {
    private boolean isInflateFinished;
    protected View mInflateView;
    private static boolean shouldRetainChildFragmentManager;
    private FragmentManager retainedChildFragmentManager;
    protected P mPresenter;
    protected MyHandler mHandler = new MyHandler(this);
    protected VaryViewHelperController mVaryViewHelperController = null;

    protected int dip2px(Context context, double dpValue) {
        if (context == null) {
            return (int)dpValue;
        }
        float density = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * (double)density + 0.5);
    }

    protected IFaqEventListener getFaqFlowListener() {
        SupportFragment supportFragment = FragmentHelper.getSupportFragment(this);
        if (supportFragment != null) {
            return supportFragment.getFaqEventListener();
        }
        return new FaqEventListenerWrapper();
    }

    public FragmentManager getRetainedChildFragmentManager() {
        if (shouldRetainChildFragmentManager) {
            if (this.retainedChildFragmentManager != null) {
                this.retainedChildFragmentManager = this.getChildFragmentManager();
            }
            return this.retainedChildFragmentManager;
        }
        return this.getChildFragmentManager();
    }

    public Context getContext() {
        Context context = super.getContext();
        return context != null ? context : AIHelpContext.getInstance().getContext();
    }

    private void initPresenter() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            Class presenterClass = (Class)types[0];
            if (presenterClass == IPresenter.class) {
                return;
            }
            try {
                Constructor constructor = presenterClass.getDeclaredConstructor(Context.class);
                this.mPresenter = (IPresenter)constructor.newInstance(this.getContext());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.mPresenter != null) {
            this.mPresenter.attachView((BaseFragment)this);
        }
    }

    public void onAttach(Context context) {
        Const.isNestedFragmentOnResume = false;
        super.onAttach(AIHelpContext.getLocaleUpdatedContext(context, Const.CORRECT_LANGUAGE));
        if (this.isBindEventBus()) {
            EventBus.getDefault().register(this);
        }
        try {
            this.setRetainInstance(true);
        }
        catch (Exception e) {
            shouldRetainChildFragmentManager = true;
        }
        if (shouldRetainChildFragmentManager && this.retainedChildFragmentManager != null) {
            try {
                Field childFMField = Fragment.class.getDeclaredField("mChildFragmentManager");
                childFMField.setAccessible(true);
                childFMField.set(this, this.retainedChildFragmentManager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onResume() {
        super.onResume();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Const.isNestedFragmentOnResume = true;
            }
        }, 300L);
    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        if (!enter && !this.isRemoving()) {
            AlphaAnimation doNothingAnimation = new AlphaAnimation(1.0f, 1.0f);
            doNothingAnimation.setDuration(200L);
            return doNothingAnimation;
        }
        return super.onCreateAnimation(transit, enter, nextAnim);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        ViewGroup parent;
        if (this.mInflateView == null && !this.isInflateFinished) {
            if (this.getLayout() != 0) {
                this.mInflateView = inflater.inflate(this.getLayout(), null);
            } else {
                return super.onCreateView(inflater, container, savedInstanceState);
            }
        }
        if (this.mInflateView != null && (parent = (ViewGroup)this.mInflateView.getParent()) != null) {
            parent.removeView(this.mInflateView);
        }
        return this.mInflateView;
    }

    protected int getLoadingTargetViewId() {
        return 0;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (!this.isInflateFinished) {
            this.initPresenter();
            View targetView = view.findViewById(this.getLoadingTargetViewId());
            if (targetView != null && this.mVaryViewHelperController == null) {
                this.mVaryViewHelperController = new VaryViewHelperController(targetView);
            }
            this.mInflateView = view;
            if (null != this.getArguments()) {
                this.getBundleBeforeDataPrepared(this.getArguments());
            }
            this.initEventAndData(view);
            if (null != this.getArguments()) {
                this.getBundleAfterDataPrepared(this.getArguments());
            }
            this.isInflateFinished = true;
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.isBindEventBus()) {
            EventBus.getDefault().unregister(this);
        }
        this.isInflateFinished = false;
        this.mInflateView = null;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onNetworkStateChanged(NetworkState networkState) {
    }

    public <T extends View> T get(String viewId) {
        return (T)this.mInflateView.findViewById(ResResolver.getViewId(viewId));
    }

    public Activity getActivity(Fragment fragment) {
        if (fragment == null) {
            return null;
        }
        while (fragment.getParentFragment() != null) {
            fragment = fragment.getParentFragment();
        }
        return fragment.getActivity();
    }

    @Override
    public void showLoading() {
        if (this.checkVaryViewHelper()) {
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseFragment.this.mVaryViewHelperController.showLoading("");
                }
            });
        }
    }

    @Override
    public void showEmpty(final int ... layoutId) {
        if (this.checkVaryViewHelper()) {
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseFragment.this.mVaryViewHelperController.showEmpty(layoutId);
                }
            });
        }
    }

    @Override
    public void showEmpty(final View view) {
        if (this.checkVaryViewHelper()) {
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseFragment.this.mVaryViewHelperController.showEmpty(view);
                }
            });
        }
    }

    @Override
    public void restoreViewState() {
        if (this.checkVaryViewHelper()) {
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseFragment.this.mVaryViewHelperController.restore();
                }
            });
        }
    }

    @Override
    public void showError(final String msg) {
        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ToastUtil.INSTANCE.makeRawToast(BaseFragment.this.getContext(), msg);
            }
        });
    }

    @Override
    public void showNetError() {
        if (this.checkVaryViewHelper()) {
            ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseFragment.this.mVaryViewHelperController.showNetworkError();
                }
            });
        }
    }

    private boolean checkVaryViewHelper() {
        if (null == this.mVaryViewHelperController) {
            TLog.d("You must return a right target view for loading");
            return false;
        }
        return true;
    }

    protected boolean isBindEventBus() {
        return false;
    }

    protected void handleMsg(Message msg) {
    }

    protected void getBundleBeforeDataPrepared(Bundle extras) {
    }

    protected void getBundleAfterDataPrepared(Bundle extras) {
    }

    protected abstract void initEventAndData(View var1);

    protected abstract int getLayout();

    public static class MyHandler
    extends Handler {
        private WeakReference<BaseFragment> mActivity;

        public MyHandler(BaseFragment fragment) {
            this.mActivity = new WeakReference<BaseFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            if (this.mActivity.get() != null) {
                ((BaseFragment)this.mActivity.get()).handleMsg(msg);
            }
        }
    }
}

