/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.InputStream;
import net.aihelp.core.ui.glide.BitmapTypeRequest;
import net.aihelp.core.ui.glide.DownloadOptions;
import net.aihelp.core.ui.glide.DrawableRequestBuilder;
import net.aihelp.core.ui.glide.GenericTranscodeRequest;
import net.aihelp.core.ui.glide.GifTypeRequest;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.RequestManager;
import net.aihelp.core.ui.glide.load.model.ImageVideoModelLoader;
import net.aihelp.core.ui.glide.load.model.ImageVideoWrapper;
import net.aihelp.core.ui.glide.load.model.ModelLoader;
import net.aihelp.core.ui.glide.load.resource.drawable.GlideDrawable;
import net.aihelp.core.ui.glide.load.resource.gifbitmap.GifBitmapWrapper;
import net.aihelp.core.ui.glide.load.resource.transcode.ResourceTranscoder;
import net.aihelp.core.ui.glide.manager.Lifecycle;
import net.aihelp.core.ui.glide.manager.RequestTracker;
import net.aihelp.core.ui.glide.provider.DataLoadProvider;
import net.aihelp.core.ui.glide.provider.FixedLoadProvider;
import net.aihelp.core.ui.glide.request.FutureTarget;
import net.aihelp.core.ui.glide.request.target.Target;

public class DrawableTypeRequest<ModelType>
extends DrawableRequestBuilder<ModelType>
implements DownloadOptions {
    private final ModelLoader<ModelType, InputStream> streamModelLoader;
    private final ModelLoader<ModelType, ParcelFileDescriptor> fileDescriptorModelLoader;
    private final RequestManager.OptionsApplier optionsApplier;

    private static <A, Z, R> FixedLoadProvider<A, ImageVideoWrapper, Z, R> buildProvider(Glide glide, ModelLoader<A, InputStream> streamModelLoader, ModelLoader<A, ParcelFileDescriptor> fileDescriptorModelLoader, Class<Z> resourceClass, Class<R> transcodedClass, ResourceTranscoder<Z, R> transcoder) {
        if (streamModelLoader == null && fileDescriptorModelLoader == null) {
            return null;
        }
        if (transcoder == null) {
            transcoder = glide.buildTranscoder(resourceClass, transcodedClass);
        }
        DataLoadProvider<ImageVideoWrapper, Z> dataLoadProvider = glide.buildDataProvider(ImageVideoWrapper.class, resourceClass);
        ImageVideoModelLoader<A> modelLoader = new ImageVideoModelLoader<A>(streamModelLoader, fileDescriptorModelLoader);
        return new FixedLoadProvider(modelLoader, transcoder, dataLoadProvider);
    }

    DrawableTypeRequest(Class<ModelType> modelClass, ModelLoader<ModelType, InputStream> streamModelLoader, ModelLoader<ModelType, ParcelFileDescriptor> fileDescriptorModelLoader, Context context, Glide glide, RequestTracker requestTracker, Lifecycle lifecycle, RequestManager.OptionsApplier optionsApplier) {
        super(context, modelClass, DrawableTypeRequest.buildProvider(glide, streamModelLoader, fileDescriptorModelLoader, GifBitmapWrapper.class, GlideDrawable.class, null), glide, requestTracker, lifecycle);
        this.streamModelLoader = streamModelLoader;
        this.fileDescriptorModelLoader = fileDescriptorModelLoader;
        this.optionsApplier = optionsApplier;
    }

    public BitmapTypeRequest<ModelType> asBitmap() {
        return this.optionsApplier.apply(new BitmapTypeRequest<ModelType>(this, this.streamModelLoader, this.fileDescriptorModelLoader, this.optionsApplier));
    }

    public GifTypeRequest<ModelType> asGif() {
        return this.optionsApplier.apply(new GifTypeRequest<ModelType>(this, this.streamModelLoader, this.optionsApplier));
    }

    @Override
    public <Y extends Target<File>> Y downloadOnly(Y target) {
        return this.getDownloadOnlyRequest().downloadOnly(target);
    }

    @Override
    public FutureTarget<File> downloadOnly(int width, int height) {
        return this.getDownloadOnlyRequest().downloadOnly(width, height);
    }

    private GenericTranscodeRequest<ModelType, InputStream, File> getDownloadOnlyRequest() {
        return this.optionsApplier.apply(new GenericTranscodeRequest<ModelType, InputStream, File>(File.class, this, this.streamModelLoader, InputStream.class, File.class, this.optionsApplier));
    }
}

