/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.engine;

import android.util.Log;
import java.io.File;
import java.io.IOException;
import net.aihelp.core.ui.glide.load.Key;
import net.aihelp.core.ui.glide.load.ResourceDecoder;
import net.aihelp.core.ui.glide.load.engine.Resource;
import net.aihelp.core.ui.glide.load.engine.cache.DiskCache;

class CacheLoader {
    private static final String TAG = "CacheLoader";
    private final DiskCache diskCache;

    public CacheLoader(DiskCache diskCache) {
        this.diskCache = diskCache;
    }

    public <Z> Resource<Z> load(Key key, ResourceDecoder<File, Z> decoder, int width, int height) {
        Resource<Z> result;
        block5: {
            File fromCache = this.diskCache.get(key);
            if (fromCache == null) {
                return null;
            }
            result = null;
            try {
                result = decoder.decode(fromCache, width, height);
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)3)) break block5;
                Log.d((String)TAG, (String)"Exception decoding image from cache", (Throwable)e);
            }
        }
        if (result == null) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to decode image from cache or not present in cache");
            }
            this.diskCache.delete(key);
        }
        return result;
    }
}

