/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.engine.bitmap_recycle;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.BaseKeyPool;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.Poolable;
import net.aihelp.core.ui.glide.util.Util;

@TargetApi(value=19)
public class SizeConfigStrategy
implements LruPoolStrategy {
    private static final int MAX_SIZE_MULTIPLE = 8;
    private static final Bitmap.Config[] ARGB_8888_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_8888, null};
    private static final Bitmap.Config[] RGB_565_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.RGB_565};
    private static final Bitmap.Config[] ARGB_4444_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_4444};
    private static final Bitmap.Config[] ALPHA_8_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ALPHA_8};
    private final KeyPool keyPool = new KeyPool();
    private final GroupedLinkedMap<Key, Bitmap> groupedMap = new GroupedLinkedMap();
    private final Map<Bitmap.Config, NavigableMap<Integer, Integer>> sortedSizes = new HashMap<Bitmap.Config, NavigableMap<Integer, Integer>>();

    @Override
    public void put(Bitmap bitmap) {
        int size = Util.getBitmapByteSize(bitmap);
        Key key = this.keyPool.get(size, bitmap.getConfig());
        this.groupedMap.put(key, bitmap);
        NavigableMap<Integer, Integer> sizes = this.getSizesForConfig(bitmap.getConfig());
        Integer current = (Integer)sizes.get(key.size);
        sizes.put(key.size, current == null ? 1 : current + 1);
    }

    @Override
    public Bitmap get(int width, int height, Bitmap.Config config) {
        int size = Util.getBitmapByteSize(width, height, config);
        Key targetKey = this.keyPool.get(size, config);
        Key bestKey = this.findBestKey(targetKey, size, config);
        Bitmap result = this.groupedMap.get(bestKey);
        if (result != null) {
            this.decrementBitmapOfSize(Util.getBitmapByteSize(result), result.getConfig());
            result.reconfigure(width, height, result.getConfig() != null ? result.getConfig() : Bitmap.Config.ARGB_8888);
        }
        return result;
    }

    private Key findBestKey(Key key, int size, Bitmap.Config config) {
        Key result = key;
        for (Bitmap.Config possibleConfig : SizeConfigStrategy.getInConfigs(config)) {
            NavigableMap<Integer, Integer> sizesForPossibleConfig = this.getSizesForConfig(possibleConfig);
            Integer possibleSize = sizesForPossibleConfig.ceilingKey(size);
            if (possibleSize == null || possibleSize > size * 8) continue;
            if (possibleSize == size && !(possibleConfig == null ? config != null : !possibleConfig.equals((Object)config))) break;
            this.keyPool.offer(key);
            result = this.keyPool.get(possibleSize, possibleConfig);
            break;
        }
        return result;
    }

    @Override
    public Bitmap removeLast() {
        Bitmap removed = this.groupedMap.removeLast();
        if (removed != null) {
            int removedSize = Util.getBitmapByteSize(removed);
            this.decrementBitmapOfSize(removedSize, removed.getConfig());
        }
        return removed;
    }

    private void decrementBitmapOfSize(Integer size, Bitmap.Config config) {
        NavigableMap<Integer, Integer> sizes = this.getSizesForConfig(config);
        Integer current = (Integer)sizes.get(size);
        if (current == 1) {
            sizes.remove(size);
        } else {
            sizes.put(size, current - 1);
        }
    }

    private NavigableMap<Integer, Integer> getSizesForConfig(Bitmap.Config config) {
        NavigableMap<Integer, Integer> sizes = this.sortedSizes.get(config);
        if (sizes == null) {
            sizes = new TreeMap<Integer, Integer>();
            this.sortedSizes.put(config, sizes);
        }
        return sizes;
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        int size = Util.getBitmapByteSize(bitmap);
        return SizeConfigStrategy.getBitmapString(size, bitmap.getConfig());
    }

    @Override
    public String logBitmap(int width, int height, Bitmap.Config config) {
        int size = Util.getBitmapByteSize(width, height, config);
        return SizeConfigStrategy.getBitmapString(size, config);
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("SizeConfigStrategy{groupedMap=").append(this.groupedMap).append(", sortedSizes=(");
        for (Map.Entry<Bitmap.Config, NavigableMap<Integer, Integer>> entry : this.sortedSizes.entrySet()) {
            sb.append(entry.getKey()).append('[').append(entry.getValue()).append("], ");
        }
        if (!this.sortedSizes.isEmpty()) {
            sb.replace(sb.length() - 2, sb.length(), "");
        }
        return sb.append(")}").toString();
    }

    private static String getBitmapString(int size, Bitmap.Config config) {
        return "[" + size + "](" + config + ")";
    }

    private static Bitmap.Config[] getInConfigs(Bitmap.Config requested) {
        switch (requested) {
            case ARGB_8888: {
                return ARGB_8888_IN_CONFIGS;
            }
            case RGB_565: {
                return RGB_565_IN_CONFIGS;
            }
            case ARGB_4444: {
                return ARGB_4444_IN_CONFIGS;
            }
            case ALPHA_8: {
                return ALPHA_8_IN_CONFIGS;
            }
        }
        return new Bitmap.Config[]{requested};
    }

    static final class Key
    implements Poolable {
        private final KeyPool pool;
        private int size;
        private Bitmap.Config config;

        public Key(KeyPool pool) {
            this.pool = pool;
        }

        Key(KeyPool pool, int size, Bitmap.Config config) {
            this(pool);
            this.init(size, config);
        }

        public void init(int size, Bitmap.Config config) {
            this.size = size;
            this.config = config;
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public String toString() {
            return SizeConfigStrategy.getBitmapString(this.size, this.config);
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return this.size == other.size && (this.config == null ? other.config == null : this.config.equals((Object)other.config));
            }
            return false;
        }

        public int hashCode() {
            int result = this.size;
            result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
            return result;
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        public Key get(int size, Bitmap.Config config) {
            Key result = (Key)this.get();
            result.init(size, config);
            return result;
        }

        @Override
        protected Key create() {
            return new Key(this);
        }
    }
}

