/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.engine.cache;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.aihelp.core.ui.glide.load.Key;

final class DiskCacheWriteLocker {
    private final Map<Key, WriteLock> locks = new HashMap<Key, WriteLock>();
    private final WriteLockPool writeLockPool = new WriteLockPool();

    DiskCacheWriteLocker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(Key key) {
        WriteLock writeLock;
        DiskCacheWriteLocker diskCacheWriteLocker = this;
        synchronized (diskCacheWriteLocker) {
            writeLock = this.locks.get(key);
            if (writeLock == null) {
                writeLock = this.writeLockPool.obtain();
                this.locks.put(key, writeLock);
            }
            ++writeLock.interestedThreads;
        }
        writeLock.lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(Key key) {
        WriteLock writeLock;
        DiskCacheWriteLocker diskCacheWriteLocker = this;
        synchronized (diskCacheWriteLocker) {
            writeLock = this.locks.get(key);
            if (writeLock == null || writeLock.interestedThreads <= 0) {
                throw new IllegalArgumentException("Cannot release a lock that is not held, key: " + key + ", interestedThreads: " + (writeLock == null ? 0 : writeLock.interestedThreads));
            }
            if (--writeLock.interestedThreads == 0) {
                WriteLock removed = this.locks.remove(key);
                if (!removed.equals(writeLock)) {
                    throw new IllegalStateException("Removed the wrong lock, expected to remove: " + writeLock + ", but actually removed: " + removed + ", key: " + key);
                }
                this.writeLockPool.offer(removed);
            }
        }
        writeLock.lock.unlock();
    }

    private static class WriteLockPool {
        private static final int MAX_POOL_SIZE = 10;
        private final Queue<WriteLock> pool = new ArrayDeque<WriteLock>();

        private WriteLockPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WriteLock obtain() {
            WriteLock result;
            Queue<WriteLock> queue = this.pool;
            synchronized (queue) {
                result = this.pool.poll();
            }
            if (result == null) {
                result = new WriteLock();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(WriteLock writeLock) {
            Queue<WriteLock> queue = this.pool;
            synchronized (queue) {
                if (this.pool.size() < 10) {
                    this.pool.offer(writeLock);
                }
            }
        }
    }

    private static class WriteLock {
        final Lock lock = new ReentrantLock();
        int interestedThreads;

        private WriteLock() {
        }
    }
}

