/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.engine.cache;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.aihelp.core.ui.glide.load.Key;
import net.aihelp.core.ui.glide.util.LruCache;
import net.aihelp.core.ui.glide.util.Util;

class SafeKeyGenerator {
    private final LruCache<Key, String> loadIdToSafeHash = new LruCache(1000);

    SafeKeyGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSafeKey(Key key) {
        String safeKey;
        LruCache<Key, String> lruCache = this.loadIdToSafeHash;
        synchronized (lruCache) {
            safeKey = this.loadIdToSafeHash.get(key);
        }
        if (safeKey == null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                key.updateDiskCacheKey(messageDigest);
                safeKey = Util.sha256BytesToHex(messageDigest.digest());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            lruCache = this.loadIdToSafeHash;
            synchronized (lruCache) {
                this.loadIdToSafeHash.put(key, safeKey);
            }
        }
        return safeKey;
    }
}

