/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.model.stream;

import android.content.Context;
import android.net.Uri;
import java.io.InputStream;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.load.data.DataFetcher;
import net.aihelp.core.ui.glide.load.data.StreamAssetPathFetcher;
import net.aihelp.core.ui.glide.load.data.StreamLocalUriFetcher;
import net.aihelp.core.ui.glide.load.model.GenericLoaderFactory;
import net.aihelp.core.ui.glide.load.model.GlideUrl;
import net.aihelp.core.ui.glide.load.model.ModelLoader;
import net.aihelp.core.ui.glide.load.model.ModelLoaderFactory;
import net.aihelp.core.ui.glide.load.model.UriLoader;
import net.aihelp.core.ui.glide.load.model.stream.StreamModelLoader;

public class StreamUriLoader
extends UriLoader<InputStream>
implements StreamModelLoader<Uri> {
    public StreamUriLoader(Context context) {
        this(context, (ModelLoader<GlideUrl, InputStream>)Glide.buildStreamModelLoader(GlideUrl.class, context));
    }

    public StreamUriLoader(Context context, ModelLoader<GlideUrl, InputStream> urlLoader) {
        super(context, urlLoader);
    }

    @Override
    protected DataFetcher<InputStream> getLocalUriFetcher(Context context, Uri uri) {
        return new StreamLocalUriFetcher(context, uri);
    }

    @Override
    protected DataFetcher<InputStream> getAssetPathFetcher(Context context, String assetPath) {
        return new StreamAssetPathFetcher(context.getApplicationContext().getAssets(), assetPath);
    }

    public static class Factory
    implements ModelLoaderFactory<Uri, InputStream> {
        @Override
        public ModelLoader<Uri, InputStream> build(Context context, GenericLoaderFactory factories) {
            return new StreamUriLoader(context, factories.buildModelLoader(GlideUrl.class, InputStream.class));
        }

        @Override
        public void teardown() {
        }
    }
}

