/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.resource.bitmap;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Queue;
import java.util.Set;
import net.aihelp.core.ui.glide.load.DecodeFormat;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.BitmapPool;
import net.aihelp.core.ui.glide.load.resource.bitmap.BitmapDecoder;
import net.aihelp.core.ui.glide.load.resource.bitmap.ImageHeaderParser;
import net.aihelp.core.ui.glide.load.resource.bitmap.RecyclableBufferedInputStream;
import net.aihelp.core.ui.glide.load.resource.bitmap.TransformationUtils;
import net.aihelp.core.ui.glide.util.ByteArrayPool;
import net.aihelp.core.ui.glide.util.ExceptionCatchingInputStream;
import net.aihelp.core.ui.glide.util.MarkEnforcingInputStream;
import net.aihelp.core.ui.glide.util.Util;

public abstract class Downsampler
implements BitmapDecoder<InputStream> {
    private static final String TAG = "Downsampler";
    private static final Set<ImageHeaderParser.ImageType> TYPES_THAT_USE_POOL = EnumSet.of(ImageHeaderParser.ImageType.JPEG, ImageHeaderParser.ImageType.PNG_A, ImageHeaderParser.ImageType.PNG);
    private static final Queue<BitmapFactory.Options> OPTIONS_QUEUE = Util.createQueue(0);
    public static final Downsampler AT_LEAST = new Downsampler(){

        @Override
        protected int getSampleSize(int inWidth, int inHeight, int outWidth, int outHeight) {
            return Math.min(inHeight / outHeight, inWidth / outWidth);
        }

        @Override
        public String getId() {
            return "AT_LEAST.net.aihelp.core.ui.glide.load.data.bitmap";
        }
    };
    public static final Downsampler AT_MOST = new Downsampler(){

        @Override
        protected int getSampleSize(int inWidth, int inHeight, int outWidth, int outHeight) {
            int lesserOrEqualSampleSize;
            int maxIntegerFactor = (int)Math.ceil(Math.max((float)inHeight / (float)outHeight, (float)inWidth / (float)outWidth));
            return lesserOrEqualSampleSize << ((lesserOrEqualSampleSize = Math.max(1, Integer.highestOneBit(maxIntegerFactor))) < maxIntegerFactor ? 1 : 0);
        }

        @Override
        public String getId() {
            return "AT_MOST.net.aihelp.core.ui.glide.load.data.bitmap";
        }
    };
    public static final Downsampler NONE = new Downsampler(){

        @Override
        protected int getSampleSize(int inWidth, int inHeight, int outWidth, int outHeight) {
            return 0;
        }

        @Override
        public String getId() {
            return "NONE.net.aihelp.core.ui.glide.load.data.bitmap";
        }
    };
    private static final int MARK_POSITION = 0x500000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap decode(InputStream is, BitmapPool pool, int outWidth, int outHeight, DecodeFormat decodeFormat) {
        ByteArrayPool byteArrayPool = ByteArrayPool.get();
        byte[] bytesForOptions = byteArrayPool.getBytes();
        byte[] bytesForStream = byteArrayPool.getBytes();
        BitmapFactory.Options options = Downsampler.getDefaultOptions();
        RecyclableBufferedInputStream bufferedStream = new RecyclableBufferedInputStream(is, bytesForStream);
        ExceptionCatchingInputStream exceptionStream = ExceptionCatchingInputStream.obtain(bufferedStream);
        MarkEnforcingInputStream invalidatingStream = new MarkEnforcingInputStream(exceptionStream);
        try {
            exceptionStream.mark(0x500000);
            int orientation = 0;
            try {
                orientation = new ImageHeaderParser(exceptionStream).getOrientation();
            }
            catch (IOException e) {
                if (Log.isLoggable((String)TAG, (int)5)) {
                    Log.w((String)TAG, (String)"Cannot determine the image orientation from header", (Throwable)e);
                }
            }
            finally {
                block18: {
                    try {
                        exceptionStream.reset();
                    }
                    catch (IOException e) {
                        if (!Log.isLoggable((String)TAG, (int)5)) break block18;
                        Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)e);
                    }
                }
            }
            options.inTempStorage = bytesForOptions;
            int[] inDimens = this.getDimensions(invalidatingStream, bufferedStream, options);
            int inWidth = inDimens[0];
            int inHeight = inDimens[1];
            int degreesToRotate = TransformationUtils.getExifOrientationDegrees(orientation);
            int sampleSize = this.getRoundedSampleSize(degreesToRotate, inWidth, inHeight, outWidth, outHeight);
            Bitmap downsampled = this.downsampleWithSize(invalidatingStream, bufferedStream, options, pool, inWidth, inHeight, sampleSize, decodeFormat);
            IOException streamException = exceptionStream.getException();
            if (streamException != null) {
                throw new RuntimeException(streamException);
            }
            Bitmap rotated = null;
            if (downsampled != null && !downsampled.equals(rotated = TransformationUtils.rotateImageExif(downsampled, pool, orientation)) && !pool.put(downsampled)) {
                downsampled.recycle();
            }
            Bitmap bitmap = rotated;
            return bitmap;
        }
        finally {
            byteArrayPool.releaseBytes(bytesForOptions);
            byteArrayPool.releaseBytes(bytesForStream);
            exceptionStream.release();
            Downsampler.releaseOptions(options);
        }
    }

    private int getRoundedSampleSize(int degreesToRotate, int inWidth, int inHeight, int outWidth, int outHeight) {
        int targetHeight = outHeight == Integer.MIN_VALUE ? inHeight : outHeight;
        int targetWidth = outWidth == Integer.MIN_VALUE ? inWidth : outWidth;
        int exactSampleSize = degreesToRotate == 90 || degreesToRotate == 270 ? this.getSampleSize(inHeight, inWidth, targetWidth, targetHeight) : this.getSampleSize(inWidth, inHeight, targetWidth, targetHeight);
        int powerOfTwoSampleSize = exactSampleSize == 0 ? 0 : Integer.highestOneBit(exactSampleSize);
        return Math.max(1, powerOfTwoSampleSize);
    }

    private Bitmap downsampleWithSize(MarkEnforcingInputStream is, RecyclableBufferedInputStream bufferedStream, BitmapFactory.Options options, BitmapPool pool, int inWidth, int inHeight, int sampleSize, DecodeFormat decodeFormat) {
        Bitmap.Config config = Downsampler.getConfig(is, decodeFormat);
        options.inSampleSize = sampleSize;
        options.inPreferredConfig = config;
        if ((options.inSampleSize == 1 || 19 <= Build.VERSION.SDK_INT) && Downsampler.shouldUsePool(is)) {
            int targetWidth = (int)Math.ceil((double)inWidth / (double)sampleSize);
            int targetHeight = (int)Math.ceil((double)inHeight / (double)sampleSize);
            Downsampler.setInBitmap(options, pool.getDirty(targetWidth, targetHeight, config));
        }
        return Downsampler.decodeStream(is, bufferedStream, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldUsePool(InputStream is) {
        if (19 <= Build.VERSION.SDK_INT) {
            return true;
        }
        is.mark(1024);
        try {
            ImageHeaderParser.ImageType type = new ImageHeaderParser(is).getType();
            boolean bl = TYPES_THAT_USE_POOL.contains((Object)type);
            return bl;
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Cannot determine the image type from header", (Throwable)e);
            }
        }
        finally {
            block14: {
                try {
                    is.reset();
                }
                catch (IOException e) {
                    if (!Log.isLoggable((String)TAG, (int)5)) break block14;
                    Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap.Config getConfig(InputStream is, DecodeFormat format) {
        if (format == DecodeFormat.ALWAYS_ARGB_8888 || format == DecodeFormat.PREFER_ARGB_8888 || Build.VERSION.SDK_INT == 16) {
            return Bitmap.Config.ARGB_8888;
        }
        boolean hasAlpha = false;
        is.mark(1024);
        try {
            hasAlpha = new ImageHeaderParser(is).hasAlpha();
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)("Cannot determine whether the image has alpha or not from header for format " + (Object)((Object)format)), (Throwable)e);
            }
        }
        finally {
            block14: {
                try {
                    is.reset();
                }
                catch (IOException e) {
                    if (!Log.isLoggable((String)TAG, (int)5)) break block14;
                    Log.w((String)TAG, (String)"Cannot reset the input stream", (Throwable)e);
                }
            }
        }
        return hasAlpha ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
    }

    protected abstract int getSampleSize(int var1, int var2, int var3, int var4);

    public int[] getDimensions(MarkEnforcingInputStream is, RecyclableBufferedInputStream bufferedStream, BitmapFactory.Options options) {
        options.inJustDecodeBounds = true;
        Downsampler.decodeStream(is, bufferedStream, options);
        options.inJustDecodeBounds = false;
        return new int[]{options.outWidth, options.outHeight};
    }

    private static Bitmap decodeStream(MarkEnforcingInputStream is, RecyclableBufferedInputStream bufferedStream, BitmapFactory.Options options) {
        Bitmap result;
        block5: {
            if (options.inJustDecodeBounds) {
                is.mark(0x500000);
            } else {
                bufferedStream.fixMarkLimit();
            }
            result = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            try {
                if (options.inJustDecodeBounds) {
                    is.reset();
                }
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)6)) break block5;
                Log.e((String)TAG, (String)("Exception loading inDecodeBounds=" + options.inJustDecodeBounds + " sample=" + options.inSampleSize), (Throwable)e);
            }
        }
        return result;
    }

    @TargetApi(value=11)
    private static void setInBitmap(BitmapFactory.Options options, Bitmap recycled) {
        if (11 <= Build.VERSION.SDK_INT) {
            options.inBitmap = recycled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    private static synchronized BitmapFactory.Options getDefaultOptions() {
        BitmapFactory.Options decodeBitmapOptions;
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            decodeBitmapOptions = OPTIONS_QUEUE.poll();
        }
        if (decodeBitmapOptions == null) {
            decodeBitmapOptions = new BitmapFactory.Options();
            Downsampler.resetOptions(decodeBitmapOptions);
        }
        return decodeBitmapOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseOptions(BitmapFactory.Options decodeBitmapOptions) {
        Downsampler.resetOptions(decodeBitmapOptions);
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            OPTIONS_QUEUE.offer(decodeBitmapOptions);
        }
    }

    @TargetApi(value=11)
    private static void resetOptions(BitmapFactory.Options decodeBitmapOptions) {
        decodeBitmapOptions.inTempStorage = null;
        decodeBitmapOptions.inDither = false;
        decodeBitmapOptions.inScaled = false;
        decodeBitmapOptions.inSampleSize = 1;
        decodeBitmapOptions.inPreferredConfig = null;
        decodeBitmapOptions.inJustDecodeBounds = false;
        decodeBitmapOptions.outWidth = 0;
        decodeBitmapOptions.outHeight = 0;
        decodeBitmapOptions.outMimeType = null;
        if (11 <= Build.VERSION.SDK_INT) {
            decodeBitmapOptions.inBitmap = null;
            decodeBitmapOptions.inMutable = true;
        }
    }
}

