/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import net.aihelp.core.ui.glide.load.ResourceDecoder;
import net.aihelp.core.ui.glide.load.engine.Resource;
import net.aihelp.core.ui.glide.load.model.ImageVideoWrapper;

public class ImageVideoBitmapDecoder
implements ResourceDecoder<ImageVideoWrapper, Bitmap> {
    private static final String TAG = "ImageVideoDecoder";
    private final ResourceDecoder<InputStream, Bitmap> streamDecoder;
    private final ResourceDecoder<ParcelFileDescriptor, Bitmap> fileDescriptorDecoder;

    public ImageVideoBitmapDecoder(ResourceDecoder<InputStream, Bitmap> streamDecoder, ResourceDecoder<ParcelFileDescriptor, Bitmap> fileDescriptorDecoder) {
        this.streamDecoder = streamDecoder;
        this.fileDescriptorDecoder = fileDescriptorDecoder;
    }

    @Override
    public Resource<Bitmap> decode(ImageVideoWrapper source, int width, int height) throws IOException {
        ParcelFileDescriptor fileDescriptor;
        Resource<Bitmap> result;
        block4: {
            result = null;
            InputStream is = source.getStream();
            if (is != null) {
                try {
                    result = this.streamDecoder.decode(is, width, height);
                }
                catch (IOException e) {
                    if (!Log.isLoggable((String)TAG, (int)2)) break block4;
                    Log.v((String)TAG, (String)"Failed to load image from stream, trying FileDescriptor", (Throwable)e);
                }
            }
        }
        if (result == null && (fileDescriptor = source.getFileDescriptor()) != null) {
            result = this.fileDescriptorDecoder.decode(fileDescriptor, width, height);
        }
        return result;
    }

    @Override
    public String getId() {
        return "ImageVideoBitmapDecoder.net.aihelp.core.ui.glide.load.resource.bitmap";
    }
}

