/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.resource.gif;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.UUID;
import net.aihelp.core.ui.glide.GenericRequestBuilder;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.gifdecoder.GifDecoder;
import net.aihelp.core.ui.glide.load.Encoder;
import net.aihelp.core.ui.glide.load.Key;
import net.aihelp.core.ui.glide.load.Transformation;
import net.aihelp.core.ui.glide.load.engine.DiskCacheStrategy;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.BitmapPool;
import net.aihelp.core.ui.glide.load.resource.NullEncoder;
import net.aihelp.core.ui.glide.load.resource.gif.GifFrameModelLoader;
import net.aihelp.core.ui.glide.load.resource.gif.GifFrameResourceDecoder;
import net.aihelp.core.ui.glide.request.animation.GlideAnimation;
import net.aihelp.core.ui.glide.request.target.SimpleTarget;

class GifFrameLoader {
    private final FrameCallback callback;
    private final GifDecoder gifDecoder;
    private final Handler handler;
    private boolean isRunning = false;
    private boolean isLoadPending = false;
    private GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> requestBuilder;
    private DelayTarget current;
    private boolean isCleared;

    public GifFrameLoader(Context context, FrameCallback callback, GifDecoder gifDecoder, int width, int height) {
        this(callback, gifDecoder, null, GifFrameLoader.getRequestBuilder(context, gifDecoder, width, height, Glide.get(context).getBitmapPool()));
    }

    GifFrameLoader(FrameCallback callback, GifDecoder gifDecoder, Handler handler, GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> requestBuilder) {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper(), (Handler.Callback)new FrameLoaderCallback());
        }
        this.callback = callback;
        this.gifDecoder = gifDecoder;
        this.handler = handler;
        this.requestBuilder = requestBuilder;
    }

    public void setFrameTransformation(Transformation<Bitmap> transformation) {
        if (transformation == null) {
            throw new NullPointerException("Transformation must not be null");
        }
        this.requestBuilder = this.requestBuilder.transform(transformation);
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.isCleared = false;
        this.loadNextFrame();
    }

    public void stop() {
        this.isRunning = false;
    }

    public void clear() {
        this.stop();
        if (this.current != null) {
            Glide.clear(this.current);
            this.current = null;
        }
        this.isCleared = true;
    }

    public Bitmap getCurrentFrame() {
        return this.current != null ? this.current.getResource() : null;
    }

    private void loadNextFrame() {
        if (!this.isRunning || this.isLoadPending) {
            return;
        }
        this.isLoadPending = true;
        long targetTime = SystemClock.uptimeMillis() + (long)this.gifDecoder.getNextDelay();
        this.gifDecoder.advance();
        DelayTarget next = new DelayTarget(this.handler, this.gifDecoder.getCurrentFrameIndex(), targetTime);
        this.requestBuilder.signature(new FrameSignature()).into(next);
    }

    void onFrameReady(DelayTarget delayTarget) {
        if (this.isCleared) {
            this.handler.obtainMessage(2, (Object)delayTarget).sendToTarget();
            return;
        }
        DelayTarget previous = this.current;
        this.current = delayTarget;
        this.callback.onFrameReady(delayTarget.index);
        if (previous != null) {
            this.handler.obtainMessage(2, (Object)previous).sendToTarget();
        }
        this.isLoadPending = false;
        this.loadNextFrame();
    }

    private static GenericRequestBuilder<GifDecoder, GifDecoder, Bitmap, Bitmap> getRequestBuilder(Context context, GifDecoder gifDecoder, int width, int height, BitmapPool bitmapPool) {
        GifFrameResourceDecoder frameResourceDecoder = new GifFrameResourceDecoder(bitmapPool);
        GifFrameModelLoader frameLoader = new GifFrameModelLoader();
        Encoder sourceEncoder = NullEncoder.get();
        return Glide.with(context).using(frameLoader, GifDecoder.class).load(gifDecoder).as(Bitmap.class).sourceEncoder(sourceEncoder).decoder(frameResourceDecoder).skipMemoryCache(true).diskCacheStrategy(DiskCacheStrategy.NONE).override(width, height);
    }

    static class FrameSignature
    implements Key {
        private final UUID uuid;

        public FrameSignature() {
            this(UUID.randomUUID());
        }

        FrameSignature(UUID uuid) {
            this.uuid = uuid;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof FrameSignature) {
                FrameSignature other = (FrameSignature)o;
                return other.uuid.equals(this.uuid);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.uuid.hashCode();
        }

        @Override
        public void updateDiskCacheKey(MessageDigest messageDigest) throws UnsupportedEncodingException {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    static class DelayTarget
    extends SimpleTarget<Bitmap> {
        private final Handler handler;
        private final int index;
        private final long targetTime;
        private Bitmap resource;

        public DelayTarget(Handler handler, int index, long targetTime) {
            this.handler = handler;
            this.index = index;
            this.targetTime = targetTime;
        }

        public Bitmap getResource() {
            return this.resource;
        }

        @Override
        public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
            this.resource = resource;
            Message msg = this.handler.obtainMessage(1, (Object)this);
            this.handler.sendMessageAtTime(msg, this.targetTime);
        }
    }

    private class FrameLoaderCallback
    implements Handler.Callback {
        public static final int MSG_DELAY = 1;
        public static final int MSG_CLEAR = 2;

        private FrameLoaderCallback() {
        }

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                DelayTarget target = (DelayTarget)msg.obj;
                GifFrameLoader.this.onFrameReady(target);
                return true;
            }
            if (msg.what == 2) {
                DelayTarget target = (DelayTarget)msg.obj;
                Glide.clear(target);
            }
            return false;
        }
    }

    public static interface FrameCallback {
        public void onFrameReady(int var1);
    }
}

