/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.loading.indicator;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;

public class BallSpinFadeLoaderIndicator {
    private View mTarget;
    public static final float SCALE = 1.0f;
    public static final int ALPHA = 255;
    float[] scaleFloats = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    int[] alphas = new int[]{255, 255, 255, 255, 255, 255, 255, 255};

    public void setTarget(View target) {
        this.mTarget = target;
    }

    public View getTarget() {
        return this.mTarget;
    }

    public int getWidth() {
        if (this.mTarget != null) {
            return this.mTarget.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.mTarget != null) {
            return this.mTarget.getHeight();
        }
        return 0;
    }

    public void postInvalidate() {
        if (this.mTarget != null) {
            this.mTarget.postInvalidate();
        }
    }

    public void draw(Canvas canvas, Paint paint) {
        float radius = (float)this.getWidth() / 10.0f;
        for (int i = 0; i < 8; ++i) {
            canvas.save();
            Point point = this.circleAt(this.getWidth(), this.getHeight(), (float)this.getWidth() / 2.0f - radius, (double)i * 0.7853981633974483);
            canvas.translate(point.x, point.y);
            canvas.scale(this.scaleFloats[i], this.scaleFloats[i]);
            paint.setAlpha(this.alphas[i]);
            canvas.drawCircle(0.0f, 0.0f, radius, paint);
            canvas.restore();
        }
    }

    Point circleAt(int width, int height, float radius, double angle) {
        float x = (float)((double)(width / 2) + (double)radius * Math.cos(angle));
        float y = (float)((double)(height / 2) + (double)radius * Math.sin(angle));
        return new Point(x, y);
    }

    public void createAnimation() {
        int[] delays = new int[]{0, 120, 240, 360, 480, 600, 720, 780, 840};
        for (int i = 0; i < 8; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.4f, 1.0f});
            scaleAnim.setDuration(1000L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay((long)delays[i]);
            scaleAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallSpinFadeLoaderIndicator.this.scaleFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallSpinFadeLoaderIndicator.this.postInvalidate();
                }
            });
            scaleAnim.start();
            ValueAnimator alphaAnim = ValueAnimator.ofInt((int[])new int[]{255, 77, 255});
            alphaAnim.setDuration(1000L);
            alphaAnim.setRepeatCount(-1);
            alphaAnim.setStartDelay((long)delays[i]);
            alphaAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallSpinFadeLoaderIndicator.this.alphas[index] = (Integer)animation.getAnimatedValue();
                    BallSpinFadeLoaderIndicator.this.postInvalidate();
                }
            });
            alphaAnim.start();
        }
    }

    private static final class Point {
        private float x;
        private float y;

        private Point(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

