/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.loading.indicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import net.aihelp.core.ui.loading.indicator.BallSpinFadeLoaderIndicator;
import net.aihelp.utils.ResResolver;

public class LoadingIndicatorView
extends View {
    public static final int DEFAULT_SIZE = 45;
    int mIndicatorColor = -1;
    Paint mPaint;
    BallSpinFadeLoaderIndicator mIndicatorController;
    private boolean mHasAnimation;

    public LoadingIndicatorView(Context context) {
        super(context.getApplicationContext());
        this.init(null, 0);
    }

    public LoadingIndicatorView(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.init(attrs, 0);
    }

    public LoadingIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context.getApplicationContext(), attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public LoadingIndicatorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context.getApplicationContext(), attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyle) {
        int[] styleable = ResResolver.getStyleable("aihelp_loading_indicator_view");
        if (styleable != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, styleable);
            this.mIndicatorColor = a.getColor(ResResolver.getStyleableFieldIndex("aihelp_loading_indicator_view", "aihelp_loading_color"), -1);
            a.recycle();
        }
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mIndicatorColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mIndicatorController = new BallSpinFadeLoaderIndicator();
        this.mIndicatorController.setTarget(this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureDimension(this.dp2px(45), widthMeasureSpec);
        int height = this.measureDimension(this.dp2px(45), heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private int measureDimension(int defaultSize, int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? Math.min(defaultSize, specSize) : defaultSize);
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawIndicator(canvas);
    }

    public void setIndicatorColor(int mIndicatorColor) {
        this.mIndicatorColor = mIndicatorColor;
        this.mPaint.setColor(mIndicatorColor);
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mHasAnimation) {
            this.mHasAnimation = true;
            this.applyAnimation();
        }
    }

    void drawIndicator(Canvas canvas) {
        if (this.mIndicatorController != null) {
            this.mIndicatorController.draw(canvas, this.mPaint);
        }
    }

    void applyAnimation() {
        if (this.mIndicatorController != null) {
            this.mIndicatorController.setTarget(this);
            this.mIndicatorController.createAnimation();
        }
    }

    private int dp2px(int dpValue) {
        return (int)this.getContext().getResources().getDisplayMetrics().density * dpValue;
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (this.mIndicatorController != null) {
            if (visibility == 0) {
                this.mIndicatorController.setTarget(this);
                this.postInvalidate();
            } else {
                this.mIndicatorController.setTarget(null);
            }
        }
    }
}

