/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.logger.controller;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.FileUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LoggerDBController {
    private static final String TAG = LoggerDBController.class.getSimpleName();
    private JSONArray jsonArray = new JSONArray();

    public void saveCrashInfoFile(int level, String message, String stacktrace, long timeStamp) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("level", (Object)this.getLogLevel(level));
            jsonObject.put("message", (Object)message);
            jsonObject.put("stacktrace", (Object)stacktrace);
            jsonObject.put("timeStamp", timeStamp);
            this.jsonArray.put((Object)jsonObject);
            File crashFile = new File(LoggerDBController.getCrashFilePath(AIHelpContext.getInstance().getContext()));
            if (crashFile.exists()) {
                crashFile.delete();
            }
            FileOutputStream fos = new FileOutputStream(crashFile.getAbsoluteFile(), true);
            fos.write(this.jsonArray.toString().getBytes());
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"an error occured while writing file...", (Throwable)e);
        }
    }

    public static String getCrashFilePath(Context context) {
        File dirFile;
        String dirPath = "";
        File filesDir = context.getFilesDir();
        if (filesDir != null && !(dirFile = new File(dirPath = filesDir.getAbsolutePath() + "/AIHelp/crash")).exists() && dirFile.mkdirs()) {
            return dirFile.getAbsolutePath() + File.separator + "CrashLog.txt";
        }
        return dirPath + File.separator + "CrashLog.txt";
    }

    public JSONArray getCrashLog() {
        String content = FileUtil.getContentFromFile(LoggerDBController.getCrashFilePath(AIHelpContext.getInstance().getContext()));
        try {
            return new JSONArray(content);
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    public void reset() {
        this.jsonArray = new JSONArray();
    }

    public static LoggerDBController getInstance() {
        return LazyHolder.INSTANCE;
    }

    private String getLogLevel(int level) {
        switch (level) {
            case 1: {
                return "fatal";
            }
            case 2: {
                return "error";
            }
        }
        return "warn";
    }

    private static final class LazyHolder {
        static final LoggerDBController INSTANCE = new LoggerDBController();

        private LazyHolder() {
        }
    }
}

