/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.permission;

import android.content.Context;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.core.util.permission.PermissionHelper;
import net.aihelp.core.util.permission.RequestAlertHelper;

public class AIHelpPermissions {
    private Object object;
    private int requestCode = 0;
    private String[] permissions;
    private PermissionHelper helper;
    private static AIHelpPermissions sInstance;

    private AIHelpPermissions() {
    }

    public AIHelpPermissions setHost(Object object) {
        this.object = object;
        return this;
    }

    public AIHelpPermissions setRequestPermission(String ... permissions) {
        this.permissions = permissions;
        return this;
    }

    public AIHelpPermissions setRequestCode(int requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    public void request(Context context, int requestType) {
        Permission.State[] states;
        this.helper = PermissionHelper.getInstance(this.object, this.permissions, this.requestCode, requestType);
        for (Permission.State state : states = this.helper.checkPermissionState()) {
            switch (state) {
                case AVAILABLE: {
                    this.helper.invokePermissionCallback(Permission.Result.GRANTED);
                    break;
                }
                case UNAVAILABLE: {
                    this.helper.invokePermissionCallback(Permission.Result.NONE);
                    break;
                }
                case RATIONAL: {
                    this.helper.invokePermissionCallback(Permission.Result.RATIONAL);
                    break;
                }
                case ASKABLE: {
                    RequestAlertHelper.request(context, this.helper);
                }
            }
            this.helper.setInvokeId(this.requestCode);
        }
    }

    public void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        if (this.helper != null) {
            this.helper.onRequestPermissionsResult(permissions, grantResults);
        }
    }

    public void recycle() {
        this.object = null;
        if (this.helper != null) {
            this.helper.recycle();
            this.helper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AIHelpPermissions getInstance() {
        if (sInstance != null) return sInstance;
        Class<PermissionHelper> clazz = PermissionHelper.class;
        synchronized (PermissionHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new AIHelpPermissions();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }
}

