/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.permission;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import java.lang.reflect.Method;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;

public class PermissionHelper
implements IPermissionCallback {
    private Object object;
    private final String[] permissions;
    private final int requestCode;
    private final int requestType;
    private int invokeId = -1;

    private PermissionHelper(Object object, String[] permissions, int requestCode, int requestType) {
        this.object = object;
        this.permissions = permissions;
        this.requestCode = requestCode;
        this.requestType = requestType;
    }

    public static PermissionHelper getInstance(Object object, String[] permissions, int requestCode, int requestType) {
        if (object == null || permissions == null || requestCode == 0) {
            throw new IllegalArgumentException("mObject == null || permission == null || requestCode == 0!");
        }
        return new PermissionHelper(object, permissions, requestCode, requestType);
    }

    public void setInvokeId(int invokeId) {
        this.invokeId = invokeId;
    }

    public boolean avoidInvoking() {
        return this.invokeId == this.requestCode;
    }

    void invokePermissionCallback(Permission.Result result) {
        Method[] methods;
        if (this.avoidInvoking()) {
            return;
        }
        for (Method method : methods = this.object.getClass().getDeclaredMethods()) {
            Permission grantedMethod = method.getAnnotation(Permission.class);
            if (grantedMethod == null || this.requestCode != grantedMethod.requestCode()) continue;
            method.setAccessible(true);
            try {
                method.invoke(this.object, new Object[]{result, this, this.requestType});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isPermissionGranted(String permission2) {
        if (this.getActivity() != null) {
            return ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)permission2) == 0;
        }
        return false;
    }

    private Activity getActivity() {
        if (this.object instanceof Activity) {
            return (Activity)this.object;
        }
        if (this.object instanceof Fragment) {
            return ((Fragment)this.object).getActivity();
        }
        return null;
    }

    void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        this.setInvokeId(-1);
        for (int i = 0; i < grantResults.length; ++i) {
            boolean isPermissionGranted;
            boolean bl = isPermissionGranted = grantResults[i] == 0;
            if (isPermissionGranted) {
                this.invokePermissionCallback(Permission.Result.GRANTED);
            } else if (this.shouldShowRequestPermissionRationale(permissions[i])) {
                this.invokePermissionCallback(Permission.Result.DENIED);
            } else {
                this.invokePermissionCallback(Permission.Result.GO_SETTING);
            }
            this.setInvokeId(this.requestCode);
        }
    }

    Permission.State[] checkPermissionState() {
        Permission.State[] states = new Permission.State[this.permissions.length];
        for (int i = 0; i < this.permissions.length; ++i) {
            Permission.State permissionState;
            String permission2 = this.permissions[i];
            if (this.isPermissionGranted(permission2) || Build.VERSION.SDK_INT < 23) {
                permissionState = Permission.State.AVAILABLE;
            } else {
                boolean hasPermissionInManifest = PermissionHelper.hasPermissionInManifest(permission2);
                if (hasPermissionInManifest) {
                    permissionState = Permission.State.ASKABLE;
                    if (this.shouldShowRequestPermissionRationale(permission2)) {
                        permissionState = Permission.State.RATIONAL;
                    }
                } else {
                    permissionState = Permission.State.UNAVAILABLE;
                }
            }
            states[i] = permissionState;
        }
        return states;
    }

    void requestPermission() {
        Fragment fragment;
        if (this.object instanceof Activity) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.object), (String[])this.permissions, (int)this.requestCode);
        } else if (this.object instanceof Fragment && !(fragment = (Fragment)this.object).isDetached()) {
            fragment.requestPermissions(this.permissions, this.requestCode);
        }
    }

    private boolean shouldShowRequestPermissionRationale(String permission2) {
        Fragment fragment;
        if (this.object instanceof Activity) {
            if (Build.VERSION.SDK_INT >= 23) {
                return ((Activity)this.object).shouldShowRequestPermissionRationale(permission2);
            }
        } else if (this.object instanceof Fragment && !(fragment = (Fragment)this.object).isDetached()) {
            return fragment.shouldShowRequestPermissionRationale(permission2);
        }
        return false;
    }

    private static boolean hasPermissionInManifest(String permission2) {
        try {
            Context context = AIHelpContext.getInstance().getContext();
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (info.requestedPermissions != null) {
                for (String p : info.requestedPermissions) {
                    if (!p.equals(permission2)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void showSettingsPage() {
        Activity activity = this.getActivity();
        if (activity != null) {
            try {
                Intent settingsIntent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                settingsIntent.addCategory("android.intent.category.DEFAULT");
                String packageName = activity.getPackageName();
                settingsIntent.setData(Uri.parse((String)("package:" + packageName)));
                activity.startActivity(settingsIntent);
            }
            catch (ActivityNotFoundException var3) {
                Intent i = new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
                i.addCategory("android.intent.category.DEFAULT");
                activity.startActivity(i);
            }
        }
    }

    public void recycle() {
        this.object = null;
    }

    @Override
    public void onPermissionDenied() {
    }

    @Override
    public void onPermissionRational() {
        this.requestPermission();
    }

    @Override
    public void onPermissionIgnored() {
        this.showSettingsPage();
    }
}

